# Generate simple semantic map from the complex semantic map

import os
import matplotlib.pyplot as plt
import cv2
import scipy.misc as misc
import numpy as np
import os
###########################Display image##################################################################
def show(Im,Name="img"):
    print(Name)
    plt.imshow(Im)
    plt.text(0.0,0.0,Name)
    plt.show()

#######################################################################################################
MainDir=r"../../Complex/TrainAnnotations/"

Out=r"Train/"
OutSem=Out+"/Semantic/"
if not os.path.isdir(Out): os.mkdir(Out)
if not os.path.isdir(OutSem): os.mkdir(OutSem)
for  AnnDir in os.listdir(MainDir):
        print(AnnDir)
        Img=cv2.imread(MainDir + "/" + AnnDir + "/Image.png")
        InDir=MainDir+"/"+AnnDir+"/Semantic/"




        if os.path.exists(InDir+"/5_Ignore.png"):
            IgnoreMap=cv2.imread(InDir+"/5_Ignore.png")[:,:,0]
        else:
            IgnoreMap=np.zeros([Img.shape[0],Img.shape[1]])
        if not os.path.isdir(OutSem + "/5_Ignore"): os.mkdir(OutSem +"/5_Ignore")
        cv2.imwrite(OutSem +"/5_Ignore/" + AnnDir + ".png",IgnoreMap.astype(np.uint8))


        for SemFile in os.listdir(InDir):
            if (".png" not in SemFile) or (SemFile=="5_Ignore.png"): continue
            SemMap = cv2.imread(MainDir+"/"+InDir + "/"+SemFile)
            OutMap=np.zeros([SemMap.shape[0],SemMap.shape[1]])
            OutMap[SemMap[:,:,1]>0]=2 # Obstructed
            OutMap[SemMap[:, :, 0] > 0] = 1 # Is class
            OutMap[IgnoreMap > 0] = 254  # Ignore region
            SemName = SemFile[:-4]
            if not  os.path.isdir(OutSem + "/" + SemName): os.mkdir(OutSem + "/" + SemName)
            cv2.imwrite(OutSem + "/" + SemName + "/" + AnnDir + ".png", OutMap.astype(np.uint8))


