import os
import numpy as np
import cv2
import torch
from skimage.metrics import structural_similarity as compare_ssim
from skimage.metrics import peak_signal_noise_ratio, structural_similarity
from ct_utils import psnr_ssim

name = 'L109_8'
view_number = name.split('_')[-1]
recon_path = f'results_{name}/AAPM_256_ncsnpp_continuous/sparseview_CT_ADMM_TV_total/m{view_number}/rho10/lambda0.04/recon'
gt_path = f'results_{name}/AAPM_256_ncsnpp_continuous/sparseview_CT_ADMM_TV_total/m{view_number}/rho10/lambda0.04/label'
length = len([name for name in os.listdir(recon_path) if name.endswith('.png')])
# length = 100
ids = [i for i in range(length)]
recon, gt = [], []
for id in ids:
    # load png file 
    recon.append(cv2.imread(os.path.join(recon_path, f'{id}.png'), cv2.IMREAD_GRAYSCALE))
    # gt: 000.png. 001.png, ,,, 131.png
    gt.append(cv2.imread(os.path.join(gt_path, f'{id}.png'), cv2.IMREAD_GRAYSCALE))

recon_volume = np.stack(recon, axis=0) / 255
gt_volume = np.stack(gt, axis=0) / 255
# compute axial view    

psnr, ssim = peak_signal_noise_ratio(gt_volume, recon_volume), structural_similarity(gt_volume, recon_volume)
print('PSNR:', psnr, 'SSIM:', ssim)

psnr, ssim = [], []
for i in range(recon_volume.shape[2]):
    recon_axial = recon_volume[:,:,i]
    gt_axial = gt_volume[:,:,i]
    psnr_axial, ssim_axial = peak_signal_noise_ratio(gt_axial, recon_axial), structural_similarity(gt_axial, recon_axial)
    psnr.append(psnr_axial)
    ssim.append(ssim_axial)
print('coronal PSNR:', np.mean(psnr))
print('axial SSIM:', np.mean(ssim))

# compute coronal view
psnr, ssim = [], []
for i in range(recon_volume.shape[0]):
    recon_coronal = recon_volume[i,:,:]
    gt_coronal = gt_volume[i,:,:]
    # if gt_coronal.sum() == 0:
    #     continue
    psnr_coronal, ssim_coronal = peak_signal_noise_ratio(gt_coronal, recon_coronal), structural_similarity(gt_coronal, recon_coronal)
    psnr.append(psnr_coronal)
    ssim.append(ssim_coronal)
print('coronal PSNR:', np.mean(psnr))
print('coronal SSIM:', np.mean(ssim))

# compute sagittal view
psnr, ssim = [], []
for i in range(recon_volume.shape[1]):
    recon_sagittal = recon_volume[:,i,:]
    gt_sagittal = gt_volume[:,i,:]
    # if gt_sagittal.sum() == 0:
    #     continue
    psnr_sagittal, ssim_sagittal = peak_signal_noise_ratio(gt_sagittal, recon_sagittal), structural_similarity(gt_sagittal, recon_sagittal)
    psnr.append(psnr_sagittal)
    ssim.append(ssim_sagittal)
print('sagittal PSNR:', np.mean(psnr))
print('sagittal SSIM:', np.mean(ssim))
