from ct_utils import load_reconstruction, resize_and_crop_sr
import os
import cv2
import numpy as np
import torch
import torch.nn.functional as F
root = r'/data/wsking/datasets/aapm/full_3mm/L096/full_3mm'
save_root = r'/data/wsking/datasets/aapm/L096'
if not os.path.exists(save_root):
    os.makedirs(save_root)
partition, volume = load_reconstruction(root)
volume = F.interpolate(torch.tensor(volume, dtype=torch.float32)[None, ...], size=(256, 256), mode='bilinear', align_corners=False)[0]
volume = (volume - volume.min()) / (volume.max() - volume.min())
volume = np.rot90(volume.numpy(), k=1, axes=(1, 2))
for i in range(volume.shape[0]):
    image = volume[i]
    # save .npy
    np.save(os.path.join(save_root, f'{i:04d}.npy'), image)
    