import os
import numpy as np
import cv2
import torch
from ct_utils import load_reconstruction, resize_volume
from skimage.metrics import peak_signal_noise_ratio, structural_similarity
from ct_geometry_projector import ConeBeam3DProjector


recon_path = r'output/b5cf0c03-c/reconstruct_volume_30000.npy'
recon_volume = np.load(recon_path)
gt_path = 'input/gt.npy'
gt_volume = np.load(gt_path)
# compute axial view

psnr, ssim = peak_signal_noise_ratio(gt_volume, recon_volume), structural_similarity(gt_volume, recon_volume, data_range=2)
print('PSNR:', psnr, 'SSIM:', ssim)

psnr, ssim = [], []
for i in range(recon_volume.shape[2]):
    recon_axial = recon_volume[:,:,i]
    gt_axial = gt_volume[:,:,i]
    if gt_axial.sum() == 0:
        continue
    psnr_axial, ssim_axial = peak_signal_noise_ratio(gt_axial, recon_axial), structural_similarity(gt_axial, recon_axial, data_range=2)
    psnr.append(psnr_axial)
    ssim.append(ssim_axial)
print('coronal PSNR:', np.mean(psnr))
print('axial SSIM:', np.mean(ssim))

# compute coronal view
psnr, ssim = [], []
for i in range(recon_volume.shape[0]):
    recon_coronal = recon_volume[i,:,:]
    gt_coronal = gt_volume[i,:,:]
    if gt_coronal.sum() == 0:
        continue
    psnr_coronal, ssim_coronal = peak_signal_noise_ratio(gt_coronal, recon_coronal), structural_similarity(gt_coronal, recon_coronal, data_range=2)
    psnr.append(psnr_coronal)
    ssim.append(ssim_coronal)
print('coronal PSNR:', np.mean(psnr))
print('coronal SSIM:', np.mean(ssim))

# compute sagittal view
psnr, ssim = [], []
for i in range(recon_volume.shape[1]):
    recon_sagittal = recon_volume[:,i,:]
    gt_sagittal = gt_volume[:,i,:]
    if gt_sagittal.sum() == 0:
        continue
    psnr_sagittal, ssim_sagittal = peak_signal_noise_ratio(gt_sagittal, recon_sagittal), structural_similarity(gt_sagittal, recon_sagittal, data_range=2)
    psnr.append(psnr_sagittal)
    ssim.append(ssim_sagittal)
print('sagittal PSNR:', np.mean(psnr))
print('sagittal SSIM:', np.mean(ssim))

