import os
import sys


# CT experiments
exp_number = ['015','009','090','051', '071', '095', '086', '020', '083', '085', '087', '061', '053', '092', '059']
view = '90'
device = '1'
log_dir = f'log_{view}'
if not os.path.exists(log_dir):
    os.makedirs(log_dir)
for num in exp_number:
    command = f'python ct_train.py -s {num} -v {view} -d {device} > {log_dir}/{num}_{view}_{device}.txt'
    try:
        os.system(command)
    except Exception as e:
        print(f'Error in {num}')
        print(e)
        
        
# MRI experiments
indices = ['031_3', '031_4', '031_5', '041_3', '041_5', '041_4', '061_3', '061_2', '061_15', '062_2', '062_9', '062_8', '063_axial', '063_coronal', '063_sagittal']
for idx in indices:
    cmd = f'python mri_train.py -s {idx} > {idx}.txt'
    os.system(cmd)
    
    
