import os
import numpy as np
import cv2
import torch
from ct_utils import load_reconstruction, resize_volume
from skimage.metrics import structural_similarity as compare_ssim
from ct_geometry_projector import ConeBeam3DProjector

def quick_evaluation(test_output,test_data):
    mse = torch.mean((test_output - test_data)**2)
    # max_pixel_value = torch.max(test_data)
    # if max_pixel_value != 1:
    #     print('max_pixel_value:', max_pixel_value)
    test_psnr = 10 * torch.log10(1 / mse)
    test_ssim = compare_ssim(test_output.squeeze().cpu().numpy(), test_data.squeeze().cpu().numpy(), multichannel=True, data_range=2)
    # print('MSE:{:.4f}, PSNR: {:.4f}, SSIM: {:.4f}'.format(mse*255*255/1000, test_psnr, test_ssim))
    return test_psnr, test_ssim
image_size, proj_size = (128, 256, 256), (512, 800)
ct_projector = ConeBeam3DProjector(image_size, proj_size, 180)
source_path = r'/sharedata/datasets/AAPM-Mayo/full_3mm/L109/full_3mm'
partition, volume = load_reconstruction(source_path)
gt_volume = resize_volume(volume)
gt_volume = torch.from_numpy(gt_volume.copy()).unsqueeze(-1).transpose(0,3)[0]
# projs = ct_projector.forward_project(gt_volume.unsqueeze(0)) # Note whether the order is wrong !!!!!!!!!!!!
# limited_angle_projs = np.zeros_like(projs)
# limited_angle_projs[:, :limited_angle_projs.shape[1]//2] = projs[:, :limited_angle_projs.shape[1]//2]
# print(projs.shape)
# recon_volume = ct_projector.backward_project(projs)[0]  # [bs, n, h, w] -> [bs, x, y, z]
# print(recon_volume.shape)
# recon_path = r'/data/wsking/Splatting/gs/output/a26c6cce-6/reconstruct_volume_1000.npy'
# recon_path = r'/data/wsking/Splatting/gs/output/41ad8baa-c/reconstruct_volume_50.npy'
# recon_volume = torch.from_numpy(np.load(recon_path))



n_view = 180
root = f'results/SV-CT/m{n_view}.0/MCG/recon'
img_list = sorted([name for name in os.listdir(root) if name.endswith('.png') and 'clip' in name])
slice_num = len(img_list)
print(slice_num, img_list)
gt_volume = gt_volume[:,:,:slice_num]
recon_volume = []
for name in img_list:
    img_path = os.path.join(root, name)
    img = cv2.imread(img_path, cv2.IMREAD_GRAYSCALE)
    recon_volume.append(img)
recon_volume = np.stack(recon_volume, axis=2)
recon_volume = (recon_volume - np.min(recon_volume)) / (np.max(recon_volume) - np.min(recon_volume))
recon_volume = torch.from_numpy(recon_volume)
psnr, ssim = quick_evaluation(recon_volume, gt_volume)
print(psnr.item(), ssim)

# psnr, ssim = [], []

# # compute axial view
# for i in range(recon_volume.shape[2]):
#     recon_axial = recon_volume[:,:,i]
#     gt_axial = gt_volume[:,:,i]
#     psnr_axial, ssim_axial = quick_evaluation(recon_axial, gt_axial)
#     psnr.append(psnr_axial)
#     ssim.append(ssim_axial)
# print('axial PSNR:', np.mean(psnr))
# print('axial SSIM:', np.mean(ssim))

# # compute coronal view
# psnr, ssim = [], []
# for i in range(recon_volume.shape[0]):
#     recon_coronal = recon_volume[i,:,:]
#     gt_coronal = gt_volume[i,:,:]
#     psnr_coronal, ssim_coronal = quick_evaluation(recon_coronal, gt_coronal)
#     psnr.append(psnr_coronal)
#     ssim.append(ssim_coronal)
# print('coronal PSNR:', np.mean(psnr))
# print('coronal SSIM:', np.mean(ssim))

# # compute sagittal view
# psnr, ssim = [], []
# for i in range(recon_volume.shape[1]):
#     recon_sagittal = recon_volume[:,i,:]
#     gt_sagittal = gt_volume[:,i,:]
#     psnr_sagittal, ssim_sagittal = quick_evaluation(recon_sagittal, gt_sagittal)
#     psnr.append(psnr_sagittal)
#     ssim.append(ssim_sagittal)
# print('sagittal PSNR:', np.mean(psnr))
# print('sagittal SSIM:', np.mean(ssim))

