import os
import cv2
import torch
from tqdm import tqdm
from physics.ct import CT



def convert(root, save_root, size, num_proj, device='cuda:0'):
    if not os.path.exists(save_root):
        os.makedirs(save_root)
    img_list = sorted([name for name in os.listdir(root) if name.endswith('.png')])
    radon = CT(img_width=size, radon_view=num_proj, circle=False, device=torch.device(device))
    # if num_proj == 90:
    #     img_list = img_list[14900:]
    for name in tqdm(img_list):
        img = cv2.imread(os.path.join(root, name), cv2.IMREAD_GRAYSCALE)
        img = torch.from_numpy(img)[None, None, ...].float().to(torch.device(device))
        sinogram = radon.A(img)
        fbp = radon.A_dagger(sinogram).squeeze()
        fbp = (fbp - fbp.min())/(fbp.max() - fbp.min()) * 255
        fbp = fbp.cpu().numpy()
        cv2.imwrite(os.path.join(save_root, name), fbp)

def batch_convert(root, save_root, size, num_proj, device='cuda:0', batch_size=1000):
    if not os.path.exists(save_root):
        os.makedirs(save_root)
    img_list = sorted([name for name in os.listdir(root) if name.endswith('.png')])
    radon = CT(img_width=size, radon_view=num_proj, circle=False, device=torch.device(device))
    
    for i in tqdm(range(0, len(img_list), batch_size)):
        img_batch = []
        for name in img_list[i:i+batch_size]:
            img = cv2.imread(os.path.join(root, name), cv2.IMREAD_GRAYSCALE)
            img = torch.from_numpy(img)[None, None, ...].float().to(torch.device(device))
            img_batch.append(img)
        img_batch = torch.cat(img_batch, dim=0)
        sinogram = radon.A(img_batch)
        fbp = radon.A_dagger(sinogram)
        for j, name in enumerate(img_list[i:i+batch_size]):
            fbp_j = fbp[j].squeeze()
            fbp_j = (fbp_j - fbp_j.min())/(fbp_j.max() - fbp_j.min()) * 255
            fbp_j = fbp_j.cpu().numpy()
            cv2.imwrite(os.path.join(save_root, name), fbp_j)
    
    
if __name__ == '__main__':
    img_size = 512
    img_root = '/sharedata/datasets/CTMRI/CT1mm/053'
    for nv in [60]:
        save_root = f'/sharedata/datasets/CTMRI/CT1mm/053_{nv}'
        convert(img_root, save_root, img_size, nv)