import os
import numpy as np
import cv2
from skimage.metrics import peak_signal_noise_ratio as psnr, structural_similarity as ssim
root = 'batch_result'
img_root = '/sharedata/datasets/CTMRI/CT1mm/test'
names = sorted([name for name in os.listdir(root) if os.path.isdir(os.path.join(root, name))])
for name in names:
    path = os.path.join(root, name)
    reference_image = cv2.imread(os.path.join(img_root, f'{name}_0001.png'), cv2.IMREAD_GRAYSCALE)
    for view in [60, 90, 120, 180]:
        sub_path = os.path.join(path, str(view), 'reconstruction')
        try:
            # results = sorted([float(name.split('.png')[0].split('_')[-1]) for name in os.listdir(sub_path) if name.endswith('.png') and '1499' in name])
            
            img_names = sorted([name for name in os.listdir(sub_path) if '1499' in name])
            psnr_results, ssim_results = [], []
            for img_name in img_names:
                img = cv2.imread(os.path.join(sub_path, img_name), cv2.IMREAD_GRAYSCALE)
                psnr_value, ssim_value = psnr(reference_image, img), ssim(reference_image, img)
                psnr_results.append(psnr_value)
                ssim_results.append(ssim_value)
            print(name, view, np.mean(psnr_results), np.mean(ssim_results))
        except:
            continue