import os
import shutil
import sitk
import pydicom
from tqdm import tqdm

def structure_test():
    dirs = sorted(name for name in os.listdir(root) if os.path.isdir(os.path.join(root,name)))
    for name in dirs:
        path = os.path.join(root,name)
        subfolder = os.path.join(path,os.listdir(path)[0])
        assert 'StudyInfo.dat' in os.listdir(subfolder)

def relabeling():
    dirs = sorted(name for name in os.listdir(root) if os.path.isdir(os.path.join(root,name)))
    for name in tqdm(dirs):
        print(name)
        path0 = os.path.join(root,name)
        subfolder = os.path.join(path0,os.listdir(path0)[0])
        assert 'StudyInfo.dat' in os.listdir(subfolder)
        uid = name[:3]
        path = os.path.join(root,uid)
        os.rename(subfolder,path)
        if 'StudyInfo.dat' in os.listdir(path):
            os.remove(os.path.join(path,'StudyInfo.dat'))
        # assert there are two folders in the path
        cts = [os.path.join(path,name) for name in os.listdir(path) if os.path.isdir(os.path.join(path,name))]
        assert len(cts) == 2
        counts = [len(os.listdir(ct)) for ct in cts]
        # the one with more files is 1mm and the other is 3mm
        assert counts[0] != counts[1]
        if counts[0] > counts[1]:
            ct1mm = cts[0]
            ct3mm = cts[1]
        else:
            ct1mm = cts[1]
            ct3mm = cts[0]
        # # rename the folders with 1mm and 3mm
        os.rename(ct1mm,os.path.join(path,'full_1mm'))
        os.rename(ct3mm,os.path.join(path,'full_3mm'))




def dcm2image():
    dirs = sorted(name for name in os.listdir(root) if os.path.isdir(os.path.join(root,name)))
    for name in tqdm(dirs[1:]):
        uid = name[:3]
        path = os.path.join(root,uid)
        path_1mm = os.path.join(path,'full_1mm')
        path_3mm = os.path.join(path,'full_3mm')
        processes = [path_1mm,path_3mm]
        for process in processes:
            dcm_list = sorted(name for name in os.listdir(process) if name.endswith('.dcm'))
            save_path = os.path.join(process,'images0')
            if os.path.exists(save_path):
                shutil.rmtree(save_path)
            os.makedirs(save_path)
            for (i,name) in enumerate(dcm_list):
                dcm_path = os.path.join(process,name)
                resp = sitk.convert_image(dcm_path,os.path.join(save_path,f'{i:04d}.png'))
                if not resp:
                    print(f'Error in {dcm_path}')
                    os.remove(dcm_path)
                    
pii_tags = ["PatientID", "PatientName", "PatientBirthDate", 
            "PatientSex", "PatientAge", "PatientAddress"]
            
def anonymization():
    dirs = sorted(name for name in os.listdir(root) if os.path.isdir(os.path.join(root,name)))
    for name in tqdm(dirs):
        uid = name[:3]
        path = os.path.join(root,uid)
        path_1mm = os.path.join(path,'full_1mm')
        path_3mm = os.path.join(path,'full_3mm')
        processes = [path_1mm,path_3mm]
        for process in processes:
            dcm_list = sorted(name for name in os.listdir(process) if name.endswith('.dcm'))
            for name in dcm_list:
                dcm_path = os.path.join(process,name)
                dataset = pydicom.dcmread(dcm_path)
                for tag in pii_tags:
                    if tag in dataset:
                        dataset.data_element(tag).value = ""
                dataset.save_as(dcm_path)

            
if __name__ == '__main__':
    root = '/sharedata/datasets/CTMRI/CT'
    # relabeling()
    dcm2image()
    anonymization()