namespace ActiproSoftware.ProductSamples.SyntaxEditorSamples.QuickStart.DotNetAddOnServerTags {
    using ActiproSoftware.Text.Lexing.Implementation;
    using System;
    using System.ComponentModel;
    using System.Linq;
    using System.Reflection;
    
    
    /// <summary>
    /// Contains the token IDs for the <c>Parent to C# example</c> language.
    /// </summary>
    /// <remarks>
    /// This type was generated by the Actipro Language Designer tool v14.2.610.0 (http://www.actiprosoftware.com).
    /// </remarks>
    [System.CodeDom.Compiler.GeneratedCodeAttribute("LanguageDesigner", "14.2.610.0")]
    public partial class ParentTokenId : TokenIdProviderBase {
        
        /// <summary>
        /// Gets the <c>Whitespace</c> token ID.
        /// </summary>
        public const Int32 Whitespace = 2;
        
        /// <summary>
        /// Gets the <c>Identifier</c> token ID.
        /// </summary>
        public const Int32 Identifier = 3;
        
        /// <summary>
        /// Gets the <c>DateKeyword</c> token ID.
        /// </summary>
        public const Int32 DateKeyword = 4;
        
        /// <summary>
        /// Gets the <c>ChildCodeBlockStart</c> token ID.
        /// </summary>
        public const Int32 ChildCodeBlockStart = 5;
        
        /// <summary>
        /// Gets the <c>ChildCodeBlockEnd</c> token ID.
        /// </summary>
        public const Int32 ChildCodeBlockEnd = 6;
        
        /// <summary>
        /// Gets the <c>ChildOutputBlockStart</c> token ID.
        /// </summary>
        public const Int32 ChildOutputBlockStart = 7;
        
        /// <summary>
        /// Gets the <c>ChildOutputBlockEnd</c> token ID.
        /// </summary>
        public const Int32 ChildOutputBlockEnd = 8;
        
        /// <summary>
        /// Gets the minimum token ID returned by this provider.
        /// </summary>
        /// <value>The minimum token ID returned by this provider.</value>
        public override Int32 MinId {
            get {
                return 1;
            }
        }
        
        /// <summary>
        /// Gets the maximum token ID returned by this provider.
        /// </summary>
        /// <value>The maximum token ID returned by this provider.</value>
        public override Int32 MaxId {
            get {
                return 8;
            }
        }
        
        /// <summary>
        /// Returns whether the specified ID value is valid for this token ID provider.
        /// </summary>
        /// <param name="id">The token ID to examine.</param>
        /// <returns><c>true</c> if the ID value is valid; otherwise, <c>false</c></returns>
        public override Boolean ContainsId(Int32 id) {
            return ((id >= MinId) 
                        && (id <= MaxId));
        }
        
        /// <summary>
        /// Returns the public static fields in this ID provider.
        /// </summary>
        /// <returns>The public static fields in this ID provider.</returns>
        private static FieldInfo[] GetFields() {
			#if WINRT
			return typeof(ParentTokenId).GetTypeInfo().DeclaredFields.Where(f => (f.IsPublic) && (f.IsStatic)).ToArray();
			#else
			return typeof(ParentTokenId).GetFields((BindingFlags.Public | BindingFlags.Static));
			#endif
        }
        
        /// <summary>
        /// Returns the actual string representation for the specified token ID.
        /// </summary>
        /// <param name="id">The token ID to examine.</param>
        /// <returns>The actual string representation for the specified token ID.</returns>
        public override String GetDescription(Int32 id) {
            FieldInfo[] fields = GetFields();
            for (Int32 index = 0; (index < fields.Length); index = (index + 1)) {
                FieldInfo field = fields[index];
                if (id.Equals(field.GetValue(null))) {
                    Object descriptionAttr = field.GetCustomAttributes(typeof(DescriptionAttribute), false).FirstOrDefault();
                    if ((descriptionAttr != null)) {
                        return ((DescriptionAttribute)(descriptionAttr)).Description;
                    }
                    else {
                        return field.Name;
                    }
                }
            }
            return null;
        }
        
        /// <summary>
        /// Returns the string-based key for the specified token ID.
        /// </summary>
        /// <param name="id">The token ID to examine.</param>
        /// <returns>The string-based key for the specified token ID.</returns>
        public override String GetKey(Int32 id) {
            FieldInfo[] fields = GetFields();
            for (Int32 index = 0; (index < fields.Length); index = (index + 1)) {
                FieldInfo field = fields[index];
                if (id.Equals(field.GetValue(null))) {
                    return field.Name;
                }
            }
            return null;
        }
        
        /// <summary>
        /// Returns whether the specified ID value is part of the <c>Keyword</c>.
        /// </summary>
        /// <param name="id">The token ID to examine.</param>
        /// <returns><c>true</c> if the ID value is in the classification type; otherwise, <c>false</c></returns>
        public static Boolean IsKeywordClassificationType(Int32 id) {
            return (id == DateKeyword);
        }
        
        /// <summary>
        /// Returns whether the specified ID value is part of the <c>TransitionDelimiter</c>.
        /// </summary>
        /// <param name="id">The token ID to examine.</param>
        /// <returns><c>true</c> if the ID value is in the classification type; otherwise, <c>false</c></returns>
        public static Boolean IsTransitionDelimiterClassificationType(Int32 id) {
            return ((id >= ChildCodeBlockStart) 
                        && (id <= ChildOutputBlockEnd));
        }
        
        /// <summary>
        /// Specifies a description for a property or event.
        /// </summary>
        private class DescriptionAttribute : Attribute {
            
            private String descriptionValue;
            
            /// <summary>
            /// Initializes a new instance of the <c>DescriptionAttribute</c> class.
            /// </summary>
            /// <param name="descriptionValue">The description stored in this attribute.</param>
            public DescriptionAttribute(String descriptionValue) {
                this.descriptionValue = descriptionValue;
            }
            
            /// <summary>
            /// Gets the description stored in this attribute.
            /// </summary>
            /// <value>The description stored in this attribute.</value>
            public String Description {
                get {
                    return this.descriptionValue;
                }
            }
        }
    }
}
