namespace ActiproSoftware.ProductSamples.SyntaxEditorSamples.QuickStart.GettingStarted03b {
    using ActiproSoftware.Text;
    using ActiproSoftware.Text.Lexing.Implementation;
    using ActiproSoftware.Text.Utility;
    using System;
    
    
    /// <summary>
    /// Represents a lexer for the <c>Simple</c> language.
    /// </summary>
    /// <remarks>
    /// This type was generated by the Actipro Language Designer tool v11.1.542.0 (http://www.actiprosoftware.com).
    /// Generated code is based on input created by Actipro Software LLC.
    /// Copyright (c) 2001-2019 Actipro Software LLC.  All rights reserved.
    /// </remarks>
    public partial class SimpleLexer : DynamicLexer {
        
        /// <summary>
        /// Initializes a new instance of the <c>SimpleLexer</c> class.
        /// </summary>
        /// <param name="classificationTypeProvider">A <see cref="ISimpleClassificationTypeProvider"/> that provides classification types used by this lexer.</param>
        public SimpleLexer(ISimpleClassificationTypeProvider classificationTypeProvider) {
            if ((classificationTypeProvider == null)) {
                throw new ArgumentNullException("classificationTypeProvider");
            }

            // Create lexical states
            IKeyedObservableCollection<DynamicLexicalState> lexicalStates = ((IKeyedObservableCollection<DynamicLexicalState>)(this.LexicalStates));
            this.DefaultLexicalState.Id = SimpleLexicalStateId.Default;
            lexicalStates.Add(new DynamicLexicalState(SimpleLexicalStateId.SingleLineComment, "SingleLineComment"));
            lexicalStates.Add(new DynamicLexicalState(SimpleLexicalStateId.MultiLineComment, "MultiLineComment"));

            DynamicLexicalState lexicalState = null;
            DynamicLexicalScope lexicalScope = null;
            DynamicLexicalPatternGroup lexicalPatternGroup = null;

            // Initialize the Default lexical state
            lexicalState = lexicalStates["Default"];
            lexicalState.ChildLexicalStates.Add(lexicalStates["SingleLineComment"]);
            lexicalState.ChildLexicalStates.Add(lexicalStates["MultiLineComment"]);
            lexicalPatternGroup = new DynamicLexicalPatternGroup(DynamicLexicalPatternType.Regex, "Whitespace", null);
            lexicalPatternGroup.TokenId = SimpleTokenId.Whitespace;
            lexicalPatternGroup.Patterns.Add(new DynamicLexicalPattern("{LineTerminatorWhitespace}+"));
            lexicalState.LexicalPatternGroups.Add(lexicalPatternGroup);
            lexicalPatternGroup = new DynamicLexicalPatternGroup(DynamicLexicalPatternType.Explicit, "OpenParenthesis", classificationTypeProvider.Delimiter);
            lexicalPatternGroup.TokenId = SimpleTokenId.OpenParenthesis;
            lexicalPatternGroup.Patterns.Add(new DynamicLexicalPattern("("));
            lexicalState.LexicalPatternGroups.Add(lexicalPatternGroup);
            lexicalPatternGroup = new DynamicLexicalPatternGroup(DynamicLexicalPatternType.Explicit, "CloseParenthesis", classificationTypeProvider.Delimiter);
            lexicalPatternGroup.TokenId = SimpleTokenId.CloseParenthesis;
            lexicalPatternGroup.Patterns.Add(new DynamicLexicalPattern(")"));
            lexicalState.LexicalPatternGroups.Add(lexicalPatternGroup);
            lexicalPatternGroup = new DynamicLexicalPatternGroup(DynamicLexicalPatternType.Explicit, "OpenCurlyBrace", classificationTypeProvider.Delimiter);
            lexicalPatternGroup.TokenId = SimpleTokenId.OpenCurlyBrace;
            lexicalPatternGroup.Patterns.Add(new DynamicLexicalPattern("{"));
            lexicalState.LexicalPatternGroups.Add(lexicalPatternGroup);
            lexicalPatternGroup = new DynamicLexicalPatternGroup(DynamicLexicalPatternType.Explicit, "CloseCurlyBrace", classificationTypeProvider.Delimiter);
            lexicalPatternGroup.TokenId = SimpleTokenId.CloseCurlyBrace;
            lexicalPatternGroup.Patterns.Add(new DynamicLexicalPattern("}"));
            lexicalState.LexicalPatternGroups.Add(lexicalPatternGroup);
            lexicalPatternGroup = new DynamicLexicalPatternGroup(DynamicLexicalPatternType.Explicit, "Function", classificationTypeProvider.Keyword);
            lexicalPatternGroup.TokenId = SimpleTokenId.Function;
            lexicalPatternGroup.CaseSensitivity = CaseSensitivity.Sensitive;
            lexicalPatternGroup.LookAheadPattern = "{NonWord}|\\z";
            lexicalPatternGroup.Patterns.Add(new DynamicLexicalPattern("function"));
            lexicalState.LexicalPatternGroups.Add(lexicalPatternGroup);
            lexicalPatternGroup = new DynamicLexicalPatternGroup(DynamicLexicalPatternType.Explicit, "Return", classificationTypeProvider.Keyword);
            lexicalPatternGroup.TokenId = SimpleTokenId.Return;
            lexicalPatternGroup.CaseSensitivity = CaseSensitivity.Sensitive;
            lexicalPatternGroup.LookAheadPattern = "{NonWord}|\\z";
            lexicalPatternGroup.Patterns.Add(new DynamicLexicalPattern("return"));
            lexicalState.LexicalPatternGroups.Add(lexicalPatternGroup);
            lexicalPatternGroup = new DynamicLexicalPatternGroup(DynamicLexicalPatternType.Explicit, "Var", classificationTypeProvider.Keyword);
            lexicalPatternGroup.TokenId = SimpleTokenId.Var;
            lexicalPatternGroup.CaseSensitivity = CaseSensitivity.Sensitive;
            lexicalPatternGroup.LookAheadPattern = "{NonWord}|\\z";
            lexicalPatternGroup.Patterns.Add(new DynamicLexicalPattern("var"));
            lexicalState.LexicalPatternGroups.Add(lexicalPatternGroup);
            lexicalPatternGroup = new DynamicLexicalPatternGroup(DynamicLexicalPatternType.Regex, "Identifier", classificationTypeProvider.Identifier);
            lexicalPatternGroup.TokenId = SimpleTokenId.Identifier;
            lexicalPatternGroup.Patterns.Add(new DynamicLexicalPattern("(_ | {Alpha})({Word})*"));
            lexicalState.LexicalPatternGroups.Add(lexicalPatternGroup);
            lexicalPatternGroup = new DynamicLexicalPatternGroup(DynamicLexicalPatternType.Explicit, "Equality", null);
            lexicalPatternGroup.TokenId = SimpleTokenId.Equality;
            lexicalPatternGroup.Patterns.Add(new DynamicLexicalPattern("=="));
            lexicalState.LexicalPatternGroups.Add(lexicalPatternGroup);
            lexicalPatternGroup = new DynamicLexicalPatternGroup(DynamicLexicalPatternType.Explicit, "Inequality", null);
            lexicalPatternGroup.TokenId = SimpleTokenId.Inequality;
            lexicalPatternGroup.Patterns.Add(new DynamicLexicalPattern("!="));
            lexicalState.LexicalPatternGroups.Add(lexicalPatternGroup);
            lexicalPatternGroup = new DynamicLexicalPatternGroup(DynamicLexicalPatternType.Explicit, "Assignment", null);
            lexicalPatternGroup.TokenId = SimpleTokenId.Assignment;
            lexicalPatternGroup.Patterns.Add(new DynamicLexicalPattern("="));
            lexicalState.LexicalPatternGroups.Add(lexicalPatternGroup);
            lexicalPatternGroup = new DynamicLexicalPatternGroup(DynamicLexicalPatternType.Explicit, "Addition", null);
            lexicalPatternGroup.TokenId = SimpleTokenId.Addition;
            lexicalPatternGroup.Patterns.Add(new DynamicLexicalPattern("+"));
            lexicalState.LexicalPatternGroups.Add(lexicalPatternGroup);
            lexicalPatternGroup = new DynamicLexicalPatternGroup(DynamicLexicalPatternType.Explicit, "Subtraction", null);
            lexicalPatternGroup.TokenId = SimpleTokenId.Subtraction;
            lexicalPatternGroup.Patterns.Add(new DynamicLexicalPattern("-"));
            lexicalState.LexicalPatternGroups.Add(lexicalPatternGroup);
            lexicalPatternGroup = new DynamicLexicalPatternGroup(DynamicLexicalPatternType.Explicit, "Multiplication", null);
            lexicalPatternGroup.TokenId = SimpleTokenId.Multiplication;
            lexicalPatternGroup.Patterns.Add(new DynamicLexicalPattern("*"));
            lexicalState.LexicalPatternGroups.Add(lexicalPatternGroup);
            lexicalPatternGroup = new DynamicLexicalPatternGroup(DynamicLexicalPatternType.Explicit, "Division", null);
            lexicalPatternGroup.TokenId = SimpleTokenId.Division;
            lexicalPatternGroup.Patterns.Add(new DynamicLexicalPattern("/"));
            lexicalState.LexicalPatternGroups.Add(lexicalPatternGroup);
            lexicalPatternGroup = new DynamicLexicalPatternGroup(DynamicLexicalPatternType.Explicit, "Comma", null);
            lexicalPatternGroup.TokenId = SimpleTokenId.Comma;
            lexicalPatternGroup.Patterns.Add(new DynamicLexicalPattern(","));
            lexicalState.LexicalPatternGroups.Add(lexicalPatternGroup);
            lexicalPatternGroup = new DynamicLexicalPatternGroup(DynamicLexicalPatternType.Explicit, "SemiColon", null);
            lexicalPatternGroup.TokenId = SimpleTokenId.SemiColon;
            lexicalPatternGroup.Patterns.Add(new DynamicLexicalPattern(";"));
            lexicalState.LexicalPatternGroups.Add(lexicalPatternGroup);
            lexicalPatternGroup = new DynamicLexicalPatternGroup(DynamicLexicalPatternType.Regex, "Number", classificationTypeProvider.Number);
            lexicalPatternGroup.TokenId = SimpleTokenId.Number;
            lexicalPatternGroup.LookAheadPattern = "{NonWord}|\\z";
            lexicalPatternGroup.Patterns.Add(new DynamicLexicalPattern("{Digit}* \\. {Digit}+"));
            lexicalState.LexicalPatternGroups.Add(lexicalPatternGroup);
            lexicalPatternGroup = new DynamicLexicalPatternGroup(DynamicLexicalPatternType.Regex, "Number", classificationTypeProvider.Number);
            lexicalPatternGroup.TokenId = SimpleTokenId.Number;
            lexicalPatternGroup.LookAheadPattern = "{NonWord}|\\z";
            lexicalPatternGroup.Patterns.Add(new DynamicLexicalPattern("{Digit}+"));
            lexicalState.LexicalPatternGroups.Add(lexicalPatternGroup);

            // Initialize the SingleLineComment lexical state
            lexicalState = lexicalStates["SingleLineComment"];
            lexicalState.DefaultClassificationType = classificationTypeProvider.Comment;
            lexicalState.DefaultTokenId = SimpleTokenId.SingleLineCommentText;
            lexicalState.DefaultTokenKey = "SingleLineCommentText";
            lexicalScope = new DynamicLexicalScope();
            lexicalState.LexicalScopes.Add(lexicalScope);
            lexicalPatternGroup = new DynamicLexicalPatternGroup(DynamicLexicalPatternType.Explicit, "SingleLineCommentStartDelimiter", null);
            lexicalPatternGroup.TokenId = SimpleTokenId.SingleLineCommentStartDelimiter;
            lexicalPatternGroup.Patterns.Add(new DynamicLexicalPattern("//"));
            lexicalScope.StartLexicalPatternGroup = lexicalPatternGroup;
            lexicalPatternGroup = new DynamicLexicalPatternGroup(DynamicLexicalPatternType.Regex, "SingleLineCommentEndDelimiter", null);
            lexicalPatternGroup.TokenId = SimpleTokenId.SingleLineCommentEndDelimiter;
            lexicalPatternGroup.Patterns.Add(new DynamicLexicalPattern("\\n"));
            lexicalScope.EndLexicalPatternGroup = lexicalPatternGroup;
            lexicalPatternGroup = new DynamicLexicalPatternGroup(DynamicLexicalPatternType.Regex, "SingleLineCommentText", null);
            lexicalPatternGroup.TokenId = SimpleTokenId.SingleLineCommentText;
            lexicalPatternGroup.Patterns.Add(new DynamicLexicalPattern("[^\\n]+"));
            lexicalState.LexicalPatternGroups.Add(lexicalPatternGroup);

            // Initialize the MultiLineComment lexical state
            lexicalState = lexicalStates["MultiLineComment"];
            lexicalState.DefaultClassificationType = classificationTypeProvider.Comment;
            lexicalState.DefaultTokenId = SimpleTokenId.MultiLineCommentText;
            lexicalState.DefaultTokenKey = "MultiLineCommentText";
            lexicalScope = new DynamicLexicalScope();
            lexicalState.LexicalScopes.Add(lexicalScope);
            lexicalPatternGroup = new DynamicLexicalPatternGroup(DynamicLexicalPatternType.Explicit, "MultiLineCommentStartDelimiter", null);
            lexicalPatternGroup.TokenId = SimpleTokenId.MultiLineCommentStartDelimiter;
            lexicalPatternGroup.Patterns.Add(new DynamicLexicalPattern("/*"));
            lexicalScope.StartLexicalPatternGroup = lexicalPatternGroup;
            lexicalPatternGroup = new DynamicLexicalPatternGroup(DynamicLexicalPatternType.Explicit, "MultiLineCommentEndDelimiter", null);
            lexicalPatternGroup.TokenId = SimpleTokenId.MultiLineCommentEndDelimiter;
            lexicalPatternGroup.Patterns.Add(new DynamicLexicalPattern("*/"));
            lexicalScope.EndLexicalPatternGroup = lexicalPatternGroup;
            lexicalPatternGroup = new DynamicLexicalPatternGroup(DynamicLexicalPatternType.Regex, "MultiLineCommentLineTerminator", null);
            lexicalPatternGroup.TokenId = SimpleTokenId.MultiLineCommentLineTerminator;
            lexicalPatternGroup.Patterns.Add(new DynamicLexicalPattern("\\n"));
            lexicalState.LexicalPatternGroups.Add(lexicalPatternGroup);
            lexicalPatternGroup = new DynamicLexicalPatternGroup(DynamicLexicalPatternType.Regex, "MultiLineCommentText", null);
            lexicalPatternGroup.TokenId = SimpleTokenId.MultiLineCommentText;
            lexicalPatternGroup.Patterns.Add(new DynamicLexicalPattern("[^\\*\\n]+"));
            lexicalState.LexicalPatternGroups.Add(lexicalPatternGroup);
        }
    }
}
