using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using ActiproSoftware.SyntaxEditor;
using ActiproSoftware.SampleBrowser;

namespace ActiproSoftware.ProductSamples.SyntaxEditorSamples.QuickStart.ReadOnlyRegions {

	/// <summary>
	/// A form for testing read-only regions.
	/// </summary>
	public class MainForm : System.Windows.Forms.Form {
		private ActiproSoftware.SyntaxEditor.SyntaxEditor editor;
		private System.Windows.Forms.Label editor2Label;
		private RadioButton allReadOnlyRadioButton;
		private RadioButton linesReadOnlyRadioButton;
		private RadioButton noReadOnlyRadioButton;
		private RadioButton curlyBraceReadOnlyRadioButton;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public MainForm() {
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			// Load a language
			editor.Document.LoadLanguageFromXml(Program.DynamicLexersPath + "ActiproSoftware.CSharp.xml", 0);
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose(bool disposing) {
			if (disposing) {
				if (components != null) 
					components.Dispose();
			}
			base.Dispose(disposing);
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			ActiproSoftware.SyntaxEditor.Document document1 = new ActiproSoftware.SyntaxEditor.Document();
			System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(MainForm));
			this.editor = new ActiproSoftware.SyntaxEditor.SyntaxEditor();
			this.editor2Label = new System.Windows.Forms.Label();
			this.allReadOnlyRadioButton = new System.Windows.Forms.RadioButton();
			this.linesReadOnlyRadioButton = new System.Windows.Forms.RadioButton();
			this.noReadOnlyRadioButton = new System.Windows.Forms.RadioButton();
			this.curlyBraceReadOnlyRadioButton = new System.Windows.Forms.RadioButton();
			this.SuspendLayout();
			// 
			// editor
			// 
			this.editor.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
			document1.ReadOnly = true;
			document1.Text = resources.GetString("document1.Text");
			this.editor.Document = document1;
			this.editor.Font = new System.Drawing.Font("Courier New", 9.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
			this.editor.IndicatorMarginVisible = false;
			this.editor.Location = new System.Drawing.Point(12, 89);
			this.editor.Name = "editor";
			this.editor.SelectionMarginWidth = 6;
			this.editor.Size = new System.Drawing.Size(546, 228);
			this.editor.TabIndex = 4;
			this.editor.UseDisabledRenderingForReadOnlyMode = true;
			// 
			// editor2Label
			// 
			this.editor2Label.AutoSize = true;
			this.editor2Label.Location = new System.Drawing.Point(9, 14);
			this.editor2Label.Name = "editor2Label";
			this.editor2Label.Size = new System.Drawing.Size(242, 13);
			this.editor2Label.TabIndex = 5;
			this.editor2Label.Text = "Select the range of text that should be read-only...";
			// 
			// allReadOnlyRadioButton
			// 
			this.allReadOnlyRadioButton.Checked = true;
			this.allReadOnlyRadioButton.Location = new System.Drawing.Point(57, 30);
			this.allReadOnlyRadioButton.Name = "allReadOnlyRadioButton";
			this.allReadOnlyRadioButton.Size = new System.Drawing.Size(121, 17);
			this.allReadOnlyRadioButton.TabIndex = 0;
			this.allReadOnlyRadioButton.TabStop = true;
			this.allReadOnlyRadioButton.Text = "Entire document";
			this.allReadOnlyRadioButton.CheckedChanged += new System.EventHandler(this.radioButton_CheckedChanged);
			// 
			// linesReadOnlyRadioButton
			// 
			this.linesReadOnlyRadioButton.Location = new System.Drawing.Point(193, 30);
			this.linesReadOnlyRadioButton.Name = "linesReadOnlyRadioButton";
			this.linesReadOnlyRadioButton.Size = new System.Drawing.Size(147, 17);
			this.linesReadOnlyRadioButton.TabIndex = 1;
			this.linesReadOnlyRadioButton.Text = "Lines starting with //";
			this.linesReadOnlyRadioButton.CheckedChanged += new System.EventHandler(this.radioButton_CheckedChanged);
			// 
			// noReadOnlyRadioButton
			// 
			this.noReadOnlyRadioButton.Location = new System.Drawing.Point(193, 53);
			this.noReadOnlyRadioButton.Name = "noReadOnlyRadioButton";
			this.noReadOnlyRadioButton.Size = new System.Drawing.Size(208, 17);
			this.noReadOnlyRadioButton.TabIndex = 3;
			this.noReadOnlyRadioButton.Text = "None (entire document editable)";
			this.noReadOnlyRadioButton.CheckedChanged += new System.EventHandler(this.radioButton_CheckedChanged);
			// 
			// curlyBraceReadOnlyRadioButton
			// 
			this.curlyBraceReadOnlyRadioButton.Location = new System.Drawing.Point(57, 53);
			this.curlyBraceReadOnlyRadioButton.Name = "curlyBraceReadOnlyRadioButton";
			this.curlyBraceReadOnlyRadioButton.Size = new System.Drawing.Size(121, 17);
			this.curlyBraceReadOnlyRadioButton.TabIndex = 2;
			this.curlyBraceReadOnlyRadioButton.Text = "{ ... } regions";
			this.curlyBraceReadOnlyRadioButton.CheckedChanged += new System.EventHandler(this.radioButton_CheckedChanged);
			// 
			// MainForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(570, 329);
			this.Controls.Add(this.curlyBraceReadOnlyRadioButton);
			this.Controls.Add(this.noReadOnlyRadioButton);
			this.Controls.Add(this.linesReadOnlyRadioButton);
			this.Controls.Add(this.allReadOnlyRadioButton);
			this.Controls.Add(this.editor);
			this.Controls.Add(this.editor2Label);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
			this.MaximizeBox = false;
			this.MinimizeBox = false;
			this.Name = "MainForm";
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterParent;
			this.Text = "Read-Only Document and Text Regions";
			this.ResumeLayout(false);
			this.PerformLayout();

		}
		#endregion
		
		/////////////////////////////////////////////////////////////////////////////////////////////////////
		// EVENT HANDLERS
		/////////////////////////////////////////////////////////////////////////////////////////////////////
		
		/// <summary>
		/// Occurs when the checked state is changed.
		/// </summary>
		/// <param name="sender">Sender of the event.</param>
		/// <param name="e">Event arguments.</param>
		private void radioButton_CheckedChanged(object sender, EventArgs e) {
			RadioButton radioButton = (RadioButton)sender;
			if (radioButton.Checked) {
				editor.Document.ReadOnly = (radioButton == allReadOnlyRadioButton);

				SpanIndicatorLayer layer = editor.Document.SpanIndicatorLayers[SpanIndicatorLayer.ReadOnlyKey];
				if (radioButton == linesReadOnlyRadioButton) {
					if (layer == null) {
						layer = new SpanIndicatorLayer(SpanIndicatorLayer.ReadOnlyKey, SpanIndicatorLayer.ReadOnlyDisplayPriority);
						editor.Document.SpanIndicatorLayers.Add(layer);
					}

					// Make any line starting with // to be read-only
					layer.Clear();
					foreach (DocumentLine documentLine in editor.Document.Lines) {
						if (documentLine.Text.Trim().StartsWith("//")) {
							TextRange textRange = new TextRange(documentLine.StartOffset, documentLine.EndOffset + (documentLine.EndOffset < editor.Document.Length ? 1 : 0));
							layer.Add(new ReadOnlySpanIndicator(), textRange);
						}
					}
				}
				else if (radioButton == curlyBraceReadOnlyRadioButton) {
					if (layer == null) {
						layer = new SpanIndicatorLayer(SpanIndicatorLayer.ReadOnlyKey, SpanIndicatorLayer.ReadOnlyDisplayPriority);
						editor.Document.SpanIndicatorLayers.Add(layer);
					}

					// Make any curly brace range to be read-only
					layer.Clear();
					string text = editor.Document.GetText(LineTerminator.Newline);
					int startOffset = text.IndexOf('{');
					while (startOffset != -1) {
						int endOffset = text.IndexOf('}', startOffset);
						if (endOffset == -1)
							break;

						layer.Add(new ReadOnlySpanIndicator(), new TextRange(startOffset, endOffset + 1));
						
						startOffset = text.IndexOf('{', endOffset);
					}
				}
				else if (layer != null)
					editor.Document.SpanIndicatorLayers.Remove(layer);
			}
		}
	}
}
