/*!
 * wavesurfer.js spectrogram plugin 5.2.0 (2021-08-16)
 * https://wavesurfer-js.org
 * @license BSD-3-Clause
 */
!function(e,t){"object"==typeof exports&&"object"==typeof module?module.exports=t():"function"==typeof define&&define.amd?define("WaveSurfer",[],t):"object"==typeof exports?exports.WaveSurfer=t():(e.WaveSurfer=e.WaveSurfer||{},e.WaveSurfer.spectrogram=t())}(self,(function(){return(()=>{"use strict";var e={325:(e,t)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.default=function(e,t,a,r){switch(this.bufferSize=e,this.sampleRate=t,this.bandwidth=2/e*(t/2),this.sinTable=new Float32Array(e),this.cosTable=new Float32Array(e),this.windowValues=new Float32Array(e),this.reverseTable=new Uint32Array(e),this.peakBand=0,this.peak=0,a){case"bartlett":for(i=0;i<e;i++)this.windowValues[i]=2/(e-1)*((e-1)/2-Math.abs(i-(e-1)/2));break;case"bartlettHann":for(i=0;i<e;i++)this.windowValues[i]=.62-.48*Math.abs(i/(e-1)-.5)-.38*Math.cos(2*Math.PI*i/(e-1));break;case"blackman":for(r=r||.16,i=0;i<e;i++)this.windowValues[i]=(1-r)/2-.5*Math.cos(2*Math.PI*i/(e-1))+r/2*Math.cos(4*Math.PI*i/(e-1));break;case"cosine":for(i=0;i<e;i++)this.windowValues[i]=Math.cos(Math.PI*i/(e-1)-Math.PI/2);break;case"gauss":for(r=r||.25,i=0;i<e;i++)this.windowValues[i]=Math.pow(Math.E,-.5*Math.pow((i-(e-1)/2)/(r*(e-1)/2),2));break;case"hamming":for(i=0;i<e;i++)this.windowValues[i]=.54-.46*Math.cos(2*Math.PI*i/(e-1));break;case"hann":case void 0:for(i=0;i<e;i++)this.windowValues[i]=.5*(1-Math.cos(2*Math.PI*i/(e-1)));break;case"lanczoz":for(i=0;i<e;i++)this.windowValues[i]=Math.sin(Math.PI*(2*i/(e-1)-1))/(Math.PI*(2*i/(e-1)-1));break;case"rectangular":for(i=0;i<e;i++)this.windowValues[i]=1;break;case"triangular":for(i=0;i<e;i++)this.windowValues[i]=2/e*(e/2-Math.abs(i-(e-1)/2));break;default:throw Error("No such window function '"+a+"'")}var i,s=1,n=e>>1;for(;s<e;){for(i=0;i<s;i++)this.reverseTable[i+s]=this.reverseTable[i]+n;s<<=1,n>>=1}for(i=0;i<e;i++)this.sinTable[i]=Math.sin(-Math.PI/i),this.cosTable[i]=Math.cos(-Math.PI/i);this.calculateSpectrum=function(e){var t,a,r,i=this.bufferSize,s=this.cosTable,n=this.sinTable,o=this.reverseTable,l=new Float32Array(i),h=new Float32Array(i),f=2/this.bufferSize,c=Math.sqrt,u=new Float32Array(i/2),p=Math.floor(Math.log(i)/Math.LN2);if(Math.pow(2,p)!==i)throw"Invalid buffer size, must be a power of 2.";if(i!==e.length)throw"Supplied buffer is not the same size as defined FFT. FFT Size: "+i+" Buffer Size: "+e.length;for(var d,v,w,b,m,y,M,g,k=1,x=0;x<i;x++)l[x]=e[o[x]]*this.windowValues[o[x]],h[x]=0;for(;k<i;){d=s[k],v=n[k],w=1,b=0;for(var S=0;S<k;S++){for(x=S;x<i;)y=w*l[m=x+k]-b*h[m],M=w*h[m]+b*l[m],l[m]=l[x]-y,h[m]=h[x]-M,l[x]+=y,h[x]+=M,x+=k<<1;w=(g=w)*d-b*v,b=g*v+b*d}k<<=1}x=0;for(var C=i/2;x<C;x++)(r=f*c((t=l[x])*t+(a=h[x])*a))>this.peak&&(this.peakBand=x,this.peak=r),u[x]=r;return u}},e.exports=t.default},943:(e,t,a)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.default=void 0;var r,i=(r=a(325))&&r.__esModule?r:{default:r};function s(e,t){for(var a=0;a<t.length;a++){var r=t[a];r.enumerable=r.enumerable||!1,r.configurable=!0,"value"in r&&(r.writable=!0),Object.defineProperty(e,r.key,r)}}var n=function(){function e(t,a){var r=this;!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e),this.params=t,this.wavesurfer=a,this.util=a.util,this.frequenciesDataUrl=t.frequenciesDataUrl,this._onScroll=function(e){r.updateScroll(e)},this._onRender=function(){r.render()},this._onWrapperClick=function(e){r._wrapperClickHandler(e)},this._onReady=function(){var e=r.drawer=a.drawer;if(r.container="string"==typeof t.container?document.querySelector(t.container):t.container,!r.container)throw Error("No container for WaveSurfer spectrogram");if(t.colorMap){if(t.colorMap.length<256)throw new Error("Colormap must contain 256 elements");for(var i=0;i<t.colorMap.length;i++){if(4!==t.colorMap[i].length)throw new Error("ColorMap entries must contain 4 values")}r.colorMap=t.colorMap}else{r.colorMap=[];for(var s=0;s<256;s++){var n=(255-s)/256;r.colorMap.push([n,n,n,1])}}r.width=e.width,r.pixelRatio=r.params.pixelRatio||a.params.pixelRatio,r.fftSamples=r.params.fftSamples||a.params.fftSamples||512,r.height=r.fftSamples/2,r.noverlap=t.noverlap,r.windowFunc=t.windowFunc,r.alpha=t.alpha,r.createWrapper(),r.createCanvas(),r.render(),e.wrapper.addEventListener("scroll",r._onScroll),a.on("redraw",r._onRender)}}var t,a,r;return t=e,r=[{key:"create",value:function(t){return{name:"spectrogram",deferInit:!(!t||!t.deferInit)&&t.deferInit,params:t,staticProps:{FFT:i.default},instance:e}}}],(a=[{key:"init",value:function(){this.wavesurfer.isReady?this._onReady():this.wavesurfer.once("ready",this._onReady)}},{key:"destroy",value:function(){this.unAll(),this.wavesurfer.un("ready",this._onReady),this.wavesurfer.un("redraw",this._onRender),this.drawer&&this.drawer.wrapper.removeEventListener("scroll",this._onScroll),this.wavesurfer=null,this.util=null,this.params=null,this.wrapper&&(this.wrapper.removeEventListener("click",this._onWrapperClick),this.wrapper.parentNode.removeChild(this.wrapper),this.wrapper=null)}},{key:"createWrapper",value:function(){var e=this.container.querySelector("spectrogram");e&&this.container.removeChild(e);var t=this.wavesurfer.params;if(this.wrapper=document.createElement("spectrogram"),this.params.labels){var a=this.labelsEl=document.createElement("canvas");a.classList.add("spec-labels"),this.drawer.style(a,{left:0,position:"absolute",zIndex:9,height:"".concat(this.height/this.pixelRatio,"px"),width:"".concat(55/this.pixelRatio,"px")}),this.wrapper.appendChild(a),this.loadLabels("rgba(68,68,68,0.5)","12px","10px","","#fff","#f7f7f7","center","#specLabels")}this.drawer.style(this.wrapper,{display:"block",position:"relative",userSelect:"none",webkitUserSelect:"none",height:"".concat(this.height/this.pixelRatio,"px")}),(t.fillParent||t.scrollParent)&&this.drawer.style(this.wrapper,{width:"100%",overflowX:"hidden",overflowY:"hidden"}),this.container.appendChild(this.wrapper),this.wrapper.addEventListener("click",this._onWrapperClick)}},{key:"_wrapperClickHandler",value:function(e){e.preventDefault();var t="offsetX"in e?e.offsetX:e.layerX;this.fireEvent("click",t/this.width||0)}},{key:"createCanvas",value:function(){var e=this.canvas=this.wrapper.appendChild(document.createElement("canvas"));this.spectrCc=e.getContext("2d"),this.util.style(e,{position:"absolute",zIndex:4})}},{key:"render",value:function(){this.updateCanvasStyle(),this.frequenciesDataUrl?this.loadFrequenciesData(this.frequenciesDataUrl):this.getFrequencies(this.drawSpectrogram)}},{key:"updateCanvasStyle",value:function(){var e=Math.round(this.width/this.pixelRatio)+"px";this.canvas.width=this.width,this.canvas.height=this.height,this.canvas.style.width=e}},{key:"drawSpectrogram",value:function(e,t){var a=t.spectrCc,r=t.height,i=t.width,s=t.resample(e),n=t.buffer?2/t.buffer.numberOfChannels:1;if(a){var o,l,h,f=a.createImageData(i,r);for(o=0;o<s.length;o++)for(l=0;l<s[o].length;l++){var c=t.colorMap[s[o][l]];for(h=0;h<n;h++){var u=r-l*n;2===n&&1===h&&u--;var p=u*(4*i)+4*o;f.data[p]=255*c[0],f.data[p+1]=255*c[1],f.data[p+2]=255*c[2],f.data[p+3]=255*c[3]}}a.putImageData(f,0,0)}}},{key:"getFrequencies",value:function(e){var t=this.fftSamples,a=this.buffer=this.wavesurfer.backend.buffer,r=a.getChannelData(0),s=a.length,n=a.sampleRate,o=[];if(a){var l=this.noverlap;if(!l){var h=a.length/this.canvas.width;l=Math.max(0,Math.round(t-h))}for(var f=new i.default(t,n,this.windowFunc,this.alpha),c=(Math.floor(s/(t-l)),0);c+t<r.length;){var u=r.slice(c,c+t),p=f.calculateSpectrum(u),d=new Uint8Array(t/2),v=void 0;for(v=0;v<t/2;v++)d[v]=Math.max(-255,45*Math.log10(p[v]));o.push(d),c+=t-l}e(o,this)}else this.fireEvent("error","Web Audio buffer is not available")}},{key:"loadFrequenciesData",value:function(e){var t=this,a=this.util.fetchFile({url:e});return a.on("success",(function(e){return t.drawSpectrogram(JSON.parse(e),t)})),a.on("error",(function(e){return t.fireEvent("error",e)})),a}},{key:"freqType",value:function(e){return e>=1e3?(e/1e3).toFixed(1):Math.round(e)}},{key:"unitType",value:function(e){return e>=1e3?"KHz":"Hz"}},{key:"loadLabels",value:function(e,t,a,r,i,s,n,o){e=e||"rgba(68,68,68,0)",t=t||"12px",a=a||"10px",r=r||"Helvetica",i=i||"#fff",s=s||"#fff",n=n||"center",o=o||"#specLabels";var l,h=this.height||512,f=h/256*5,c=(this.wavesurfer.backend.ac.sampleRate/2-0)/f,u=this.labelsEl.getContext("2d");if(this.labelsEl.height=this.height,this.labelsEl.width=55,u)for(u.fillStyle=e,u.fillRect(0,0,55,h),u.fill(),l=0;l<=f;l++){u.textAlign=n,u.textBaseline="middle";var p=0+c*l,d=(Math.round(p/(this.sampleRate/2)*this.fftSamples),this.freqType(p)),v=this.unitType(p),w=void 0;0==l?(w=h+l-10,u.fillStyle=s,u.font=a+" "+r,u.fillText(v,40,w),u.fillStyle=i,u.font=t+" "+r,u.fillText(d,16,w)):(w=h-50*l+2,u.fillStyle=s,u.font=a+" "+r,u.fillText(v,40,w),u.fillStyle=i,u.font=t+" "+r,u.fillText(d,16,w))}}},{key:"updateScroll",value:function(e){this.wrapper&&(this.wrapper.scrollLeft=e.target.scrollLeft)}},{key:"resample",value:function(e){var t,a=this.width,r=[],i=1/e.length,s=1/a;for(t=0;t<a;t++){var n=new Array(e[0].length),o=void 0;for(o=0;o<e.length;o++){var l=o*i,h=l+i,f=t*s,c=f+s,u=h<=f||c<=l?0:Math.min(Math.max(h,f),Math.max(c,l))-Math.max(Math.min(h,f),Math.min(c,l)),p=void 0;if(u>0)for(p=0;p<e[0].length;p++)null==n[p]&&(n[p]=0),n[p]+=u/s*e[o][p]}var d=new Uint8Array(e[0].length),v=void 0;for(v=0;v<e[0].length;v++)d[v]=n[v];r.push(d)}return r}}])&&s(t.prototype,a),r&&s(t,r),e}();t.default=n,e.exports=t.default}},t={};return function a(r){var i=t[r];if(void 0!==i)return i.exports;var s=t[r]={exports:{}};return e[r](s,s.exports,a),s.exports}(943)})()}));
