package source.hanger.demo;

import java.io.File;
import java.io.IOException;

import javax.sound.sampled.UnsupportedAudioFileException;

import lombok.extern.slf4j.Slf4j;
import source.hanger.processor.DeepFilterNetProcessor;

@Slf4j
public class WavFileDenoiseDemo {

    // 相对路径：输入 WAV 文件现在位于 dfnet-java 项目的 data 目录下
    private static final String INPUT_WAV_RELATIVE_PATH = "data/speech_with_noise_48k.wav";
    private static final String OUTPUT_DIR = "out/"; // 输出目录位于 dfnet-java 项目根目录下的 out 目录
    private static final String OUTPUT_WAV_NAME = "speech_with_noise_48k_by_java.wav";

    public static void main(String[] args) {
        // JNA 库路径现在由 DeepFilterNetNativeLib 的静态初始化块负责设置，此处不再需要。
        // String osName = System.getProperty("os.name").toLowerCase();
        // String osArch = System.getProperty("os.arch").toLowerCase();
        // String nativeLibPath = "lib/" + osName + "-" + osArch;
        // System.setProperty("jna.library.path", nativeLibPath);

        try {
            // 获取项目根目录，用于构建模型和输入文件的绝对路径
            String projectRoot = new File(".").getAbsolutePath();
            projectRoot = projectRoot.substring(0,
                projectRoot.length() - (projectRoot.endsWith(".") ? 1 : 0)); // 移除末尾可能存在的.
            if (!projectRoot.endsWith(File.separator)) {
                projectRoot += File.separator;
            }

            DeepFilterNetProcessor processor = createDeepFilterNetProcessor(projectRoot);
            processor.release(); // 确保释放资源
        } catch (Exception e) {
            log.error("DF_LOG_ERROR: 创建 DeepFilterNetProcessor 失败: {}", e.getMessage());
        }
    }

    private static DeepFilterNetProcessor createDeepFilterNetProcessor(String projectRoot)
        throws IOException, UnsupportedAudioFileException {
        String inputWavAbsolutePath = projectRoot + INPUT_WAV_RELATIVE_PATH;

        // 确保输出目录存在
        File outputDir = new File(OUTPUT_DIR);
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
        String outputWavPath = new File(outputDir, OUTPUT_WAV_NAME).getAbsolutePath();

        DeepFilterNetProcessor processor = new DeepFilterNetProcessor(100.0f);
        processor.denoiseWavFile(inputWavAbsolutePath, outputWavPath);
        return processor;
    }
}
