/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie.crf;

import edu.stanford.nlp.ie.crf.CliquePotentialFunction;
import edu.stanford.nlp.math.ArrayMath;
import edu.stanford.nlp.sequences.SeqClassifierFlags;

public class NonLinearCliquePotentialFunction
implements CliquePotentialFunction {
    private final double[][] linearWeights;
    private final double[][] inputLayerWeights;
    private final double[][] outputLayerWeights;
    private final SeqClassifierFlags flags;
    private double[] layerOneCache;
    private double[] hiddenLayerCache;

    private static double sigmoid(double x) {
        return 1.0 / (1.0 + Math.exp(-x));
    }

    public NonLinearCliquePotentialFunction(double[][] linearWeights, double[][] inputLayerWeights, double[][] outputLayerWeights, SeqClassifierFlags flags) {
        this.linearWeights = linearWeights;
        this.inputLayerWeights = inputLayerWeights;
        this.outputLayerWeights = outputLayerWeights;
        this.flags = flags;
    }

    public double[] hiddenLayerOutput(double[][] inputLayerWeights, int[] nodeCliqueFeatures, SeqClassifierFlags aFlag, double[] featureVal) {
        int i;
        int layerOneSize = inputLayerWeights.length;
        if (this.layerOneCache == null || layerOneSize != this.layerOneCache.length) {
            this.layerOneCache = new double[layerOneSize];
        }
        for (i = 0; i < layerOneSize; ++i) {
            double[] ws = inputLayerWeights[i];
            double lOneW = 0.0;
            for (int m = 0; m < nodeCliqueFeatures.length; ++m) {
                double dotProd = ws[nodeCliqueFeatures[m]];
                if (featureVal != null) {
                    dotProd *= featureVal[m];
                }
                lOneW += dotProd;
            }
            this.layerOneCache[i] = lOneW;
        }
        if (!aFlag.useHiddenLayer) {
            return this.layerOneCache;
        }
        if (this.hiddenLayerCache == null || layerOneSize != this.hiddenLayerCache.length) {
            this.hiddenLayerCache = new double[layerOneSize];
        }
        for (i = 0; i < layerOneSize; ++i) {
            this.hiddenLayerCache[i] = aFlag.useSigmoid ? NonLinearCliquePotentialFunction.sigmoid(this.layerOneCache[i]) : Math.tanh(this.layerOneCache[i]);
        }
        return this.hiddenLayerCache;
    }

    @Override
    public double computeCliquePotential(int cliqueSize, int labelIndex, int[] cliqueFeatures, double[] featureVal, int posInSent) {
        double output = 0.0;
        if (cliqueSize > 1) {
            for (int cliqueFeature : cliqueFeatures) {
                output += this.linearWeights[cliqueFeature][labelIndex];
            }
        } else {
            double[] hiddenLayer = this.hiddenLayerOutput(this.inputLayerWeights, cliqueFeatures, this.flags, featureVal);
            int outputLayerSize = this.inputLayerWeights.length / this.outputLayerWeights[0].length;
            if (this.flags.useOutputLayer) {
                double[] outputWs = this.flags.tieOutputLayer ? this.outputLayerWeights[0] : this.outputLayerWeights[labelIndex];
                if (this.flags.softmaxOutputLayer) {
                    outputWs = ArrayMath.softmax(outputWs);
                }
                for (int i = 0; i < this.inputLayerWeights.length; ++i) {
                    if (this.flags.sparseOutputLayer || this.flags.tieOutputLayer) {
                        if (i % outputLayerSize != labelIndex) continue;
                        output += outputWs[i / outputLayerSize] * hiddenLayer[i];
                        continue;
                    }
                    output += outputWs[i] * hiddenLayer[i];
                }
            } else {
                output = hiddenLayer[labelIndex];
            }
        }
        return output;
    }
}

