/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.simple;

import edu.stanford.nlp.hcoref.data.CorefChain;
import edu.stanford.nlp.ie.util.RelationTriple;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.naturalli.OperatorSpec;
import edu.stanford.nlp.naturalli.Polarity;
import edu.stanford.nlp.naturalli.SentenceFragment;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.CoreNLPProtos;
import edu.stanford.nlp.pipeline.ProtobufAnnotationSerializer;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphCoreAnnotations;
import edu.stanford.nlp.semgraph.SemanticGraphFactory;
import edu.stanford.nlp.simple.Document;
import edu.stanford.nlp.simple.SentenceAlgorithms;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.util.ArrayCoreMap;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.Quadruple;
import edu.stanford.nlp.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Sentence {
    private static Properties SINGLE_SENTENCE_DOCUMENT = new Properties(){
        {
            this.setProperty("ssplit.isOneSentence", "true");
            this.setProperty("tokenize.class", "PTBTokenizer");
            this.setProperty("tokenize.language", "en");
        }
    };
    private static Properties SINGLE_SENTENCE_TOKENIZED_DOCUMENT = new Properties(){
        {
            this.setProperty("ssplit.isOneSentence", "true");
            this.setProperty("tokenize.class", "WhitespaceTokenizer");
            this.setProperty("tokenize.language", "en");
            this.setProperty("tokenize.whitespace", "true");
        }
    };
    private final CoreNLPProtos.Sentence.Builder impl;
    private final List<CoreNLPProtos.Token.Builder> tokensBuilders;
    public final Document document;

    public Sentence(String text, Properties props) {
        this.document = new Document(text);
        if (props.containsKey("ssplit.isOneSentence")) {
            this.impl = this.document.sentence((int)0, (Properties)props).impl;
        } else {
            Properties modProps = new Properties(props);
            modProps.setProperty("ssplit.isOneSentence", "true");
            this.impl = this.document.sentence((int)0, (Properties)modProps).impl;
        }
        this.tokensBuilders = this.document.sentence((int)0).tokensBuilders;
        assert (this.document.sentence((int)0).impl == this.impl);
        assert (this.document.sentence((int)0).tokensBuilders == this.tokensBuilders);
    }

    public Sentence(String text) {
        this(text, SINGLE_SENTENCE_DOCUMENT);
    }

    public Sentence(List<String> tokens) {
        this(StringUtils.join(tokens.stream().map(x -> x.replace(' ', '\u07dd')), " "), SINGLE_SENTENCE_TOKENIZED_DOCUMENT);
        for (int i = 0; i < this.impl.getTokenCount(); ++i) {
            this.impl.getTokenBuilder(i).setWord(this.impl.getTokenBuilder(i).getWord().replace('\u07dd', ' '));
            this.impl.getTokenBuilder(i).setValue(this.impl.getTokenBuilder(i).getValue().replace('\u07dd', ' '));
            this.tokensBuilders.get(i).setWord(this.tokensBuilders.get(i).getWord().replace('\u07dd', ' '));
            this.tokensBuilders.get(i).setValue(this.tokensBuilders.get(i).getValue().replace('\u07dd', ' '));
        }
    }

    public Sentence(CoreNLPProtos.Sentence proto) {
        this.impl = proto.toBuilder();
        this.tokensBuilders = new ArrayList<CoreNLPProtos.Token.Builder>(this.impl.getTokenCount());
        for (int i = 0; i < this.impl.getTokenCount(); ++i) {
            this.tokensBuilders.add(this.impl.getToken(i).toBuilder());
        }
        this.document = new Document(proto.getText());
        this.document.forceSentences(Collections.singletonList(this));
        assert (this.document.sentence((int)0).impl == this.impl);
        assert (this.document.sentence((int)0).tokensBuilders == this.tokensBuilders);
    }

    protected Sentence(Document doc, int sentenceIndex) {
        this.document = doc;
        this.impl = doc.sentence((int)sentenceIndex).impl;
        this.tokensBuilders = doc.sentence((int)sentenceIndex).tokensBuilders;
        assert (this.document.sentence((int)sentenceIndex).impl == this.impl);
        assert (this.document.sentence((int)sentenceIndex).tokensBuilders == this.tokensBuilders);
    }

    protected Sentence(Document doc, CoreNLPProtos.Sentence.Builder proto) {
        this.document = doc;
        this.impl = proto;
        this.tokensBuilders = new ArrayList<CoreNLPProtos.Token.Builder>(this.impl.getTokenCount());
        for (int i = 0; i < this.impl.getTokenCount(); ++i) {
            this.tokensBuilders.add(this.impl.getToken(i).toBuilder());
        }
    }

    protected Sentence(Document doc, CoreNLPProtos.Sentence.Builder proto, String text) {
        this(doc, proto);
        this.impl.setText(text);
    }

    protected Sentence(Document doc, CoreMap sentence) {
        this.document = doc;
        assert (doc.sentences().size() > 0);
        this.impl = doc.sentence((int)0).impl;
        this.tokensBuilders = doc.sentence((int)0).tokensBuilders;
    }

    public Sentence(final CoreMap sentence) {
        this(new Document(new Annotation((String)sentence.get(CoreAnnotations.TextAnnotation.class)){
            {
                super(x0);
                this.set(CoreAnnotations.SentencesAnnotation.class, Collections.singletonList(sentence));
                if (sentence.containsKey(CoreAnnotations.DocIDAnnotation.class)) {
                    this.set(CoreAnnotations.DocIDAnnotation.class, sentence.get(CoreAnnotations.DocIDAnnotation.class));
                }
            }
        }), sentence);
    }

    public Sentence(final SentenceFragment sentence) {
        this(new ArrayCoreMap(32){
            {
                super(x0);
                this.set(CoreAnnotations.TokensAnnotation.class, sentence.words);
                this.set(CoreAnnotations.TextAnnotation.class, StringUtils.join(sentence.words.stream().map(CoreLabel::originalText), " "));
                if (sentence.words.isEmpty()) {
                    this.set(CoreAnnotations.TokenBeginAnnotation.class, 0);
                    this.set(CoreAnnotations.TokenEndAnnotation.class, 0);
                } else {
                    this.set(CoreAnnotations.TokenBeginAnnotation.class, sentence.words.get(0).get(CoreAnnotations.IndexAnnotation.class));
                    this.set(CoreAnnotations.TokenEndAnnotation.class, (Integer)sentence.words.get(sentence.words.size() - 1).get(CoreAnnotations.IndexAnnotation.class) + 1);
                }
                this.set(SemanticGraphCoreAnnotations.BasicDependenciesAnnotation.class, sentence.parseTree);
                this.set(SemanticGraphCoreAnnotations.CollapsedDependenciesAnnotation.class, sentence.parseTree);
                this.set(SemanticGraphCoreAnnotations.CollapsedCCProcessedDependenciesAnnotation.class, sentence.parseTree);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CoreNLPProtos.Sentence serialize() {
        CoreNLPProtos.Sentence.Builder builder = this.impl;
        synchronized (builder) {
            this.impl.clearToken();
            for (CoreNLPProtos.Token.Builder token : this.tokensBuilders) {
                this.impl.addToken(token.build());
            }
            return this.impl.build();
        }
    }

    public void serialize(OutputStream out2) throws IOException {
        this.serialize().writeDelimitedTo(out2);
        out2.flush();
    }

    public static Sentence deserialize(InputStream in) throws IOException {
        return new Sentence(CoreNLPProtos.Sentence.parseDelimitedFrom(in));
    }

    public SentenceAlgorithms algorithms() {
        return new SentenceAlgorithms(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String text() {
        CoreNLPProtos.Sentence.Builder builder = this.impl;
        synchronized (builder) {
            return this.impl.getText();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sentenceIndex() {
        CoreNLPProtos.Sentence.Builder builder = this.impl;
        synchronized (builder) {
            return this.impl.getSentenceIndex();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sentenceTokenOffsetBegin() {
        CoreNLPProtos.Sentence.Builder builder = this.impl;
        synchronized (builder) {
            return this.impl.getTokenOffsetBegin();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sentenceTokenOffsetEnd() {
        CoreNLPProtos.Sentence.Builder builder = this.impl;
        synchronized (builder) {
            return this.impl.getTokenOffsetEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> words() {
        CoreNLPProtos.Sentence.Builder builder = this.impl;
        synchronized (builder) {
            return Sentence.lazyList(this.tokensBuilders, CoreNLPProtos.Token.Builder::getWord);
        }
    }

    public String word(int index) {
        return this.words().get(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> originalTexts() {
        CoreNLPProtos.Sentence.Builder builder = this.impl;
        synchronized (builder) {
            return Sentence.lazyList(this.tokensBuilders, CoreNLPProtos.Token.Builder::getOriginalText);
        }
    }

    public String originalText(int index) {
        return this.originalTexts().get(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Integer> characterOffsetBegin() {
        CoreNLPProtos.Sentence.Builder builder = this.impl;
        synchronized (builder) {
            return Sentence.lazyList(this.tokensBuilders, CoreNLPProtos.Token.Builder::getBeginChar);
        }
    }

    public int characterOffsetBegin(int index) {
        return this.characterOffsetBegin().get(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Integer> characterOffsetEnd() {
        CoreNLPProtos.Sentence.Builder builder = this.impl;
        synchronized (builder) {
            return Sentence.lazyList(this.tokensBuilders, CoreNLPProtos.Token.Builder::getEndChar);
        }
    }

    public int characterOffsetEnd(int index) {
        return this.characterOffsetEnd().get(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> posTags(Properties props) {
        this.document.runPOS(props);
        CoreNLPProtos.Sentence.Builder builder = this.impl;
        synchronized (builder) {
            return Sentence.lazyList(this.tokensBuilders, CoreNLPProtos.Token.Builder::getPos);
        }
    }

    public List<String> posTags() {
        return this.posTags(Document.EMPTY_PROPS);
    }

    public String posTag(int index) {
        return this.posTags().get(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> lemmas(Properties props) {
        this.document.runLemma(props);
        CoreNLPProtos.Sentence.Builder builder = this.impl;
        synchronized (builder) {
            return Sentence.lazyList(this.tokensBuilders, CoreNLPProtos.Token.Builder::getLemma);
        }
    }

    public List<String> lemmas() {
        return this.lemmas(Document.EMPTY_PROPS);
    }

    public String lemma(int index) {
        return this.lemmas().get(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> nerTags(Properties props) {
        this.document.runNER(props);
        CoreNLPProtos.Sentence.Builder builder = this.impl;
        synchronized (builder) {
            return Sentence.lazyList(this.tokensBuilders, CoreNLPProtos.Token.Builder::getNer);
        }
    }

    public List<String> nerTags() {
        return this.nerTags(Document.EMPTY_PROPS);
    }

    public void regexner(String mappingFile, boolean ignorecase) {
        Properties props = new Properties();
        for (Object prop : Document.EMPTY_PROPS.keySet()) {
            props.setProperty(prop.toString(), Document.EMPTY_PROPS.getProperty(prop.toString()));
        }
        props.setProperty("regexner.mapping", mappingFile);
        props.setProperty("regexner.ignorecase", Boolean.toString(ignorecase));
        this.document.runRegexner(props);
    }

    public String nerTag(int index) {
        return this.nerTags().get(index);
    }

    public List<String> mentions(String nerTag) {
        ArrayList<String> mentionsOfTag = new ArrayList<String>();
        StringBuilder lastMention = new StringBuilder();
        String lastTag = "O";
        for (int i = 0; i < this.length(); ++i) {
            String ner = this.nerTag(i);
            if (ner.equals(nerTag) && !lastTag.equals(nerTag)) {
                lastMention.append(this.word(i)).append(' ');
            } else if (ner.equals(nerTag) && lastTag.equals(nerTag)) {
                lastMention.append(this.word(i)).append(' ');
            } else if (!ner.equals(nerTag) && lastTag.equals(nerTag)) {
                if (lastMention.length() > 0) {
                    mentionsOfTag.add(lastMention.toString().trim());
                }
                lastMention.setLength(0);
            }
            lastTag = ner;
        }
        if (lastMention.length() > 0) {
            mentionsOfTag.add(lastMention.toString().trim());
        }
        return mentionsOfTag;
    }

    public List<String> mentions() {
        ArrayList<String> mentionsOfTag = new ArrayList<String>();
        StringBuilder lastMention = new StringBuilder();
        String lastTag = "O";
        for (int i = 0; i < this.length(); ++i) {
            String ner = this.nerTag(i);
            if (!ner.equals("O") && !lastTag.equals(ner)) {
                if (lastMention.length() > 0) {
                    mentionsOfTag.add(lastMention.toString().trim());
                }
                lastMention.setLength(0);
                lastMention.append(this.word(i)).append(' ');
            } else if (!ner.equals("O") && lastTag.equals(ner)) {
                lastMention.append(this.word(i)).append(' ');
            } else if (ner.equals("O") && !lastTag.equals("O")) {
                if (lastMention.length() > 0) {
                    mentionsOfTag.add(lastMention.toString().trim());
                }
                lastMention.setLength(0);
            }
            lastTag = ner;
        }
        if (lastMention.length() > 0) {
            mentionsOfTag.add(lastMention.toString().trim());
        }
        return mentionsOfTag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tree parse(Properties props) {
        this.document.runParse(props);
        ProtobufAnnotationSerializer protobufAnnotationSerializer = this.document.serializer;
        synchronized (protobufAnnotationSerializer) {
            return this.document.serializer.fromProto(this.impl.getParseTree());
        }
    }

    public Tree parse() {
        return this.parse(Document.EMPTY_PROPS);
    }

    private CoreNLPProtos.DependencyGraph dependencies(SemanticGraphFactory.Mode mode) {
        switch (mode) {
            case COLLAPSED_TREE: {
                return this.impl.getCollapsedDependencies();
            }
            case COLLAPSED: {
                return this.impl.getCollapsedDependencies();
            }
            case CCPROCESSED: {
                return this.impl.getCollapsedCCProcessedDependencies();
            }
            case BASIC: {
                return this.impl.getBasicDependencies();
            }
        }
        throw new IllegalArgumentException("Unknown dependency type: " + (Object)((Object)mode));
    }

    public Optional<Integer> governor(Properties props, int index, SemanticGraphFactory.Mode mode) {
        this.document.runDepparse(props);
        for (CoreNLPProtos.DependencyGraph.Edge edge : this.dependencies(mode).getEdgeList()) {
            if (edge.getTarget() - 1 != index) continue;
            return Optional.of(edge.getSource() - 1);
        }
        Iterator<Object> iterator = this.impl.getBasicDependencies().getRootList().iterator();
        while (iterator.hasNext()) {
            int root = (Integer)iterator.next();
            if (index != root - 1) continue;
            return Optional.of(-1);
        }
        return Optional.empty();
    }

    public Optional<Integer> governor(Properties props, int index) {
        return this.governor(props, index, SemanticGraphFactory.Mode.COLLAPSED_TREE);
    }

    public Optional<Integer> governor(int index, SemanticGraphFactory.Mode mode) {
        return this.governor(Document.EMPTY_PROPS, index, mode);
    }

    public Optional<Integer> governor(int index) {
        return this.governor(Document.EMPTY_PROPS, index);
    }

    public List<Optional<Integer>> governors(Properties props, SemanticGraphFactory.Mode mode) {
        this.document.runDepparse(props);
        ArrayList<Optional<Integer>> governors = new ArrayList<Optional<Integer>>(this.length());
        for (int i = 0; i < this.length(); ++i) {
            governors.add(Optional.empty());
        }
        for (CoreNLPProtos.DependencyGraph.Edge edge : this.dependencies(mode).getEdgeList()) {
            governors.set(edge.getTarget() - 1, Optional.of(edge.getSource() - 1));
        }
        Iterator<Object> iterator = this.impl.getBasicDependencies().getRootList().iterator();
        while (iterator.hasNext()) {
            int root = (Integer)iterator.next();
            governors.set(root - 1, Optional.of(-1));
        }
        return governors;
    }

    public List<Optional<Integer>> governors(Properties props) {
        return this.governors(props, SemanticGraphFactory.Mode.COLLAPSED_TREE);
    }

    public List<Optional<Integer>> governors(SemanticGraphFactory.Mode mode) {
        return this.governors(Document.EMPTY_PROPS, mode);
    }

    public List<Optional<Integer>> governors() {
        return this.governors(Document.EMPTY_PROPS, SemanticGraphFactory.Mode.COLLAPSED_TREE);
    }

    public Optional<String> incomingDependencyLabel(Properties props, int index, SemanticGraphFactory.Mode mode) {
        this.document.runDepparse(props);
        for (CoreNLPProtos.DependencyGraph.Edge edge : this.dependencies(mode).getEdgeList()) {
            if (edge.getTarget() - 1 != index) continue;
            return Optional.of(edge.getDep());
        }
        Iterator<Object> iterator = this.impl.getBasicDependencies().getRootList().iterator();
        while (iterator.hasNext()) {
            int root = (Integer)iterator.next();
            if (index != root - 1) continue;
            return Optional.of("root");
        }
        return Optional.empty();
    }

    public Optional<String> incomingDependencyLabel(Properties props, int index) {
        return this.incomingDependencyLabel(props, index, SemanticGraphFactory.Mode.COLLAPSED_TREE);
    }

    public Optional<String> incomingDependencyLabel(int index, SemanticGraphFactory.Mode mode) {
        return this.incomingDependencyLabel(Document.EMPTY_PROPS, index, mode);
    }

    public Optional<String> incomingDependencyLabel(int index) {
        return this.incomingDependencyLabel(Document.EMPTY_PROPS, index);
    }

    public List<Optional<String>> incomingDependencyLabels(Properties props, SemanticGraphFactory.Mode mode) {
        this.document.runDepparse(props);
        ArrayList<Optional<String>> labels = new ArrayList<Optional<String>>(this.length());
        for (int i = 0; i < this.length(); ++i) {
            labels.add(Optional.empty());
        }
        for (CoreNLPProtos.DependencyGraph.Edge edge : this.dependencies(mode).getEdgeList()) {
            labels.set(edge.getTarget() - 1, Optional.of(edge.getDep()));
        }
        Iterator<Object> iterator = this.impl.getBasicDependencies().getRootList().iterator();
        while (iterator.hasNext()) {
            int root = (Integer)iterator.next();
            labels.set(root - 1, Optional.of("root"));
        }
        return labels;
    }

    public List<Optional<String>> incomingDependencyLabels(SemanticGraphFactory.Mode mode) {
        return this.incomingDependencyLabels(Document.EMPTY_PROPS, mode);
    }

    public List<Optional<String>> incomingDependencyLabels(Properties props) {
        return this.incomingDependencyLabels(props, SemanticGraphFactory.Mode.COLLAPSED_TREE);
    }

    public List<Optional<String>> incomingDependencyLabels() {
        return this.incomingDependencyLabels(Document.EMPTY_PROPS, SemanticGraphFactory.Mode.COLLAPSED_TREE);
    }

    public SemanticGraph dependencyGraph(Properties props, SemanticGraphFactory.Mode mode) {
        this.document.runDepparse(props);
        return ProtobufAnnotationSerializer.fromProto(this.dependencies(mode), this.asCoreLabels(new Function[0]), (String)this.document.docid().orElse(null));
    }

    public SemanticGraph dependencyGraph(Properties props) {
        return this.dependencyGraph(props, SemanticGraphFactory.Mode.COLLAPSED_TREE);
    }

    public SemanticGraph dependencyGraph() {
        return this.dependencyGraph(Document.EMPTY_PROPS, SemanticGraphFactory.Mode.COLLAPSED_TREE);
    }

    public SemanticGraph dependencyGraph(SemanticGraphFactory.Mode mode) {
        return this.dependencyGraph(Document.EMPTY_PROPS, mode);
    }

    public int length() {
        return this.impl.getTokenCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Optional<OperatorSpec>> operators(Properties props) {
        this.document.runNatlog(props);
        CoreNLPProtos.Sentence.Builder builder = this.impl;
        synchronized (builder) {
            return Sentence.lazyList(this.tokensBuilders, x -> x.hasOperator() ? Optional.of(ProtobufAnnotationSerializer.fromProto(x.getOperator())) : Optional.empty());
        }
    }

    public List<Optional<OperatorSpec>> operators() {
        return this.operators(Document.EMPTY_PROPS);
    }

    public Optional<OperatorSpec> operatorAt(Properties props, int i) {
        return this.operators(props).get(i);
    }

    public Optional<OperatorSpec> operatorAt(int i) {
        return this.operators(Document.EMPTY_PROPS).get(i);
    }

    public List<OperatorSpec> operatorsNonempty(Properties props) {
        return this.operators(props).stream().filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    public List<OperatorSpec> operatorsNonempty() {
        return this.operatorsNonempty(Document.EMPTY_PROPS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Polarity> natlogPolarities(Properties props) {
        this.document.runNatlog(props);
        CoreNLPProtos.Sentence.Builder builder = this.impl;
        synchronized (builder) {
            return Sentence.lazyList(this.tokensBuilders, x -> ProtobufAnnotationSerializer.fromProto(x.getPolarity()));
        }
    }

    public List<Polarity> natlogPolarities() {
        return this.natlogPolarities(Document.EMPTY_PROPS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Polarity natlogPolarity(Properties props, int index) {
        this.document.runNatlog(props);
        CoreNLPProtos.Sentence.Builder builder = this.impl;
        synchronized (builder) {
            return ProtobufAnnotationSerializer.fromProto(this.tokensBuilders.get(index).getPolarity());
        }
    }

    public Polarity natlogPolarity(int index) {
        return this.natlogPolarity(Document.EMPTY_PROPS, index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<RelationTriple> openieTriples(Properties props) {
        this.document.runOpenie(props);
        CoreNLPProtos.Sentence.Builder builder = this.impl;
        synchronized (builder) {
            List<CoreLabel> tokens = this.asCoreLabels(new Function[0]);
            return this.impl.getOpenieTripleList().stream().map(x -> ProtobufAnnotationSerializer.fromProto(x, tokens, (String)this.document.docid().orElse(null))).collect(Collectors.toList());
        }
    }

    public Collection<RelationTriple> openieTriples() {
        return this.openieTriples(Document.EMPTY_PROPS);
    }

    public Collection<Quadruple<String, String, String, Double>> openie() {
        this.document.runOpenie(Document.EMPTY_PROPS);
        return this.impl.getOpenieTripleList().stream().filter(proto -> proto.hasSubject() && proto.hasRelation() && proto.hasObject()).map(proto -> Quadruple.makeQuadruple(proto.getSubject(), proto.getRelation(), proto.getObject(), proto.hasConfidence() ? proto.getConfidence() : 1.0)).collect(Collectors.toList());
    }

    public Map<Integer, CorefChain> coref() {
        Map<Integer, CorefChain> allCorefs = this.document.coref();
        HashSet<Integer> toDeleteEntirely = new HashSet<Integer>();
        for (Integer clusterID : allCorefs.keySet()) {
            CorefChain chain = allCorefs.get(clusterID);
            ArrayList<CorefChain.CorefMention> mentions = new ArrayList<CorefChain.CorefMention>(chain.getMentionsInTextualOrder());
            for (CorefChain.CorefMention m : mentions) {
                if (m.sentNum == this.sentenceIndex() + 1) continue;
                chain.deleteMention(m);
            }
            if (!chain.getMentionsInTextualOrder().isEmpty()) continue;
            toDeleteEntirely.add(clusterID);
        }
        for (Integer danglingChain : toDeleteEntirely) {
            allCorefs.remove(danglingChain);
        }
        return allCorefs;
    }

    @SafeVarargs
    public final CoreMap asCoreMap(Function<Sentence, Object> ... functions) {
        for (Function<Sentence, Object> function : functions) {
            function.apply(this);
        }
        return (CoreMap)((List)this.document.asAnnotation().get(CoreAnnotations.SentencesAnnotation.class)).get(this.sentenceIndex());
    }

    @SafeVarargs
    public final List<CoreLabel> asCoreLabels(Function<Sentence, Object> ... functions) {
        for (Function<Sentence, Object> function : functions) {
            function.apply(this);
        }
        return (List)this.asCoreMap(new Function[0]).get(CoreAnnotations.TokensAnnotation.class);
    }

    public CoreNLPProtos.Token.Builder rawToken(int i) {
        return this.tokensBuilders.get(i);
    }

    public CoreNLPProtos.Sentence.Builder rawSentence() {
        return this.impl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <E> void updateTokens(List<CoreLabel> tokens, Consumer<Pair<CoreNLPProtos.Token.Builder, E>> setter, Function<CoreLabel, E> getter) {
        CoreNLPProtos.Sentence.Builder builder = this.impl;
        synchronized (builder) {
            for (int i = 0; i < tokens.size(); ++i) {
                E value = getter.apply(tokens.get(i));
                if (value == null) continue;
                setter.accept(Pair.makePair(this.tokensBuilders.get(i), value));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateParse(CoreNLPProtos.ParseTree parse) {
        CoreNLPProtos.Sentence.Builder builder = this.impl;
        synchronized (builder) {
            this.impl.setParseTree(parse);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateDependencies(CoreNLPProtos.DependencyGraph basic, CoreNLPProtos.DependencyGraph collapsed, CoreNLPProtos.DependencyGraph ccProcessed) {
        CoreNLPProtos.Sentence.Builder builder = this.impl;
        synchronized (builder) {
            this.impl.setBasicDependencies(basic);
            this.impl.setCollapsedDependencies(collapsed);
            this.impl.setCollapsedCCProcessedDependencies(ccProcessed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateTriples(Stream<CoreNLPProtos.OpenIETriple> triples) {
        CoreNLPProtos.Sentence.Builder builder = this.impl;
        synchronized (builder) {
            triples.forEach(this.impl::addOpenieTriple);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Sentence)) {
            return false;
        }
        Sentence sentence = (Sentence)o;
        if (this.impl.hasText() && !this.impl.getText().equals(sentence.impl.getText())) {
            return false;
        }
        if (this.tokensBuilders.size() != sentence.tokensBuilders.size()) {
            return false;
        }
        if (!this.impl.build().equals(sentence.impl.build())) {
            return false;
        }
        for (int i = 0; i < this.tokensBuilders.size(); ++i) {
            if (this.tokensBuilders.get(i).build().equals(sentence.tokensBuilders.get(i).build())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.impl.hasText()) {
            return this.impl.getText().hashCode() * 31 + this.tokensBuilders.size();
        }
        return this.impl.build().hashCode();
    }

    public String toString() {
        return this.impl.getText();
    }

    private static <E> List<E> lazyList(final List<CoreNLPProtos.Token.Builder> tokens, final Function<CoreNLPProtos.Token.Builder, E> fn) {
        return new AbstractList<E>(){

            @Override
            public E get(int index) {
                return fn.apply(tokens.get(index));
            }

            @Override
            public int size() {
                return tokens.size();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<String> sentenceid() {
        CoreNLPProtos.Sentence.Builder builder = this.impl;
        synchronized (builder) {
            if (this.impl.hasSentenceID()) {
                return Optional.of(this.impl.getSentenceID());
            }
            return Optional.empty();
        }
    }
}

