/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie.machinereading.domains.ace.reader;

import edu.stanford.nlp.ie.machinereading.common.DomReader;
import edu.stanford.nlp.ie.machinereading.domains.ace.reader.AceCharSeq;
import edu.stanford.nlp.ie.machinereading.domains.ace.reader.AceDocument;
import edu.stanford.nlp.ie.machinereading.domains.ace.reader.AceEntity;
import edu.stanford.nlp.ie.machinereading.domains.ace.reader.AceEntityMention;
import edu.stanford.nlp.ie.machinereading.domains.ace.reader.AceEvent;
import edu.stanford.nlp.ie.machinereading.domains.ace.reader.AceEventMention;
import edu.stanford.nlp.ie.machinereading.domains.ace.reader.AceRelation;
import edu.stanford.nlp.ie.machinereading.domains.ace.reader.AceRelationMention;
import edu.stanford.nlp.ie.machinereading.domains.ace.reader.AceRelationMentionArgument;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class AceDomReader
extends DomReader {
    private static AceCharSeq parseCharSeq(Node node) {
        Node child = AceDomReader.getChildByName(node, "charseq");
        String start = AceDomReader.getAttributeValue(child, "START");
        String end = AceDomReader.getAttributeValue(child, "END");
        String text = child.getFirstChild().getNodeValue();
        return new AceCharSeq(text, Integer.parseInt(start), Integer.parseInt(end));
    }

    private static AceEntityMention parseEntityMention(Node node) {
        String id = AceDomReader.getAttributeValue(node, "ID");
        String type = AceDomReader.getAttributeValue(node, "TYPE");
        String ldctype = AceDomReader.getAttributeValue(node, "LDCTYPE");
        AceCharSeq extent = AceDomReader.parseCharSeq(AceDomReader.getChildByName(node, "extent"));
        AceCharSeq head = AceDomReader.parseCharSeq(AceDomReader.getChildByName(node, "head"));
        return new AceEntityMention(id, type, ldctype, extent, head);
    }

    private static AceRelationMention parseRelationMention(Node node, AceDocument doc) {
        String id = AceDomReader.getAttributeValue(node, "ID");
        AceCharSeq extent = AceDomReader.parseCharSeq(AceDomReader.getChildByName(node, "extent"));
        String lc = AceDomReader.getAttributeValue(node, "LEXICALCONDITION");
        AceRelationMention mention = new AceRelationMention(id, extent, lc);
        List<Node> args = AceDomReader.getChildrenByName(node, "relation_mention_argument");
        for (Node arg : args) {
            String role = AceDomReader.getAttributeValue(arg, "ROLE");
            String refid = AceDomReader.getAttributeValue(arg, "REFID");
            AceEntityMention am = doc.getEntityMention(refid);
            if (am == null) continue;
            am.addRelationMention(mention);
            if (role.equalsIgnoreCase("arg-1")) {
                mention.getArgs()[0] = new AceRelationMentionArgument(role, am);
                continue;
            }
            if (role.equalsIgnoreCase("arg-2")) {
                mention.getArgs()[1] = new AceRelationMentionArgument(role, am);
                continue;
            }
            throw new RuntimeException("Invalid relation mention argument role: " + role);
        }
        return mention;
    }

    private static AceEventMention parseEventMention(Node node, AceDocument doc) {
        String id = AceDomReader.getAttributeValue(node, "ID");
        AceCharSeq extent = AceDomReader.parseCharSeq(AceDomReader.getChildByName(node, "extent"));
        AceCharSeq anchor = AceDomReader.parseCharSeq(AceDomReader.getChildByName(node, "anchor"));
        AceEventMention mention = new AceEventMention(id, extent, anchor);
        List<Node> args = AceDomReader.getChildrenByName(node, "event_mention_argument");
        for (Node arg : args) {
            String role = AceDomReader.getAttributeValue(arg, "ROLE");
            String refid = AceDomReader.getAttributeValue(arg, "REFID");
            AceEntityMention am = doc.getEntityMention(refid);
            if (am == null) continue;
            am.addEventMention(mention);
            mention.addArg(am, role);
        }
        return mention;
    }

    public static AceDocument parseDocument(File f) throws IOException, SAXException, ParserConfigurationException {
        Document document = AceDomReader.readDocument(f);
        Node docElement = document.getElementsByTagName("document").item(0);
        AceDocument aceDoc = new AceDocument(AceDomReader.getAttributeValue(docElement, "DOCID"));
        NodeList entities = document.getElementsByTagName("entity");
        int entityCount = 0;
        for (int i = 0; i < entities.getLength(); ++i) {
            Node node = entities.item(i);
            String id = AceDomReader.getAttributeValue(node, "ID");
            String type = AceDomReader.getAttributeValue(node, "TYPE");
            String subtype = AceDomReader.getAttributeValue(node, "SUBTYPE");
            String cls = AceDomReader.getAttributeValue(node, "CLASS");
            AceEntity entity = new AceEntity(id, type, subtype, cls);
            aceDoc.addEntity(entity);
            List<Node> mentions = AceDomReader.getChildrenByName(node, "entity_mention");
            for (Node mention1 : mentions) {
                AceEntityMention mention = AceDomReader.parseEntityMention(mention1);
                entity.addMention(mention);
                aceDoc.addEntityMention(mention);
            }
            ++entityCount;
        }
        NodeList relations = document.getElementsByTagName("relation");
        for (int i = 0; i < relations.getLength(); ++i) {
            Node node = relations.item(i);
            String id = AceDomReader.getAttributeValue(node, "ID");
            String type = AceDomReader.getAttributeValue(node, "TYPE");
            String subtype = AceDomReader.getAttributeValue(node, "SUBTYPE");
            String modality = AceDomReader.getAttributeValue(node, "MODALITY");
            String tense = AceDomReader.getAttributeValue(node, "TENSE");
            AceRelation relation = new AceRelation(id, type, subtype, modality, tense);
            aceDoc.addRelation(relation);
            List<Node> mentions = AceDomReader.getChildrenByName(node, "relation_mention");
            for (Node mention1 : mentions) {
                AceRelationMention mention = AceDomReader.parseRelationMention(mention1, aceDoc);
                relation.addMention(mention);
                aceDoc.addRelationMention(mention);
            }
        }
        NodeList events = document.getElementsByTagName("event");
        for (int i = 0; i < events.getLength(); ++i) {
            Node node = events.item(i);
            String id = AceDomReader.getAttributeValue(node, "ID");
            String type = AceDomReader.getAttributeValue(node, "TYPE");
            String subtype = AceDomReader.getAttributeValue(node, "SUBTYPE");
            String modality = AceDomReader.getAttributeValue(node, "MODALITY");
            String polarity = AceDomReader.getAttributeValue(node, "POLARITY");
            String genericity = AceDomReader.getAttributeValue(node, "GENERICITY");
            String tense = AceDomReader.getAttributeValue(node, "TENSE");
            AceEvent event = new AceEvent(id, type, subtype, modality, polarity, genericity, tense);
            aceDoc.addEvent(event);
            List<Node> mentions = AceDomReader.getChildrenByName(node, "event_mention");
            for (Node mention1 : mentions) {
                AceEventMention mention = AceDomReader.parseEventMention(mention1, aceDoc);
                event.addMention(mention);
                aceDoc.addEventMention(mention);
            }
        }
        return aceDoc;
    }

    public static void main(String[] argv) throws Exception {
        if (argv.length != 1) {
            System.err.println("Usage: java AceDomReader <APF file>");
            System.exit(1);
        }
        File f = new File(argv[0]);
        AceDocument doc = AceDomReader.parseDocument(f);
        System.out.println("Processed ACE document:\n" + doc);
        ArrayList<ArrayList<AceRelationMention>> r = doc.getAllRelationMentions();
        System.out.println("size: " + r.size());
    }
}

