/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.patterns;

import edu.stanford.nlp.patterns.CandidatePhrase;
import edu.stanford.nlp.patterns.DataInstance;
import edu.stanford.nlp.patterns.PatternFactory;
import edu.stanford.nlp.patterns.dep.DepPattern;
import edu.stanford.nlp.patterns.dep.DepPatternFactory;
import edu.stanford.nlp.patterns.surface.SurfacePattern;
import edu.stanford.nlp.patterns.surface.SurfacePatternFactory;
import edu.stanford.nlp.patterns.surface.Token;
import edu.stanford.nlp.util.CollectionValuedMap;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class Pattern
implements Serializable {
    public PatternFactory.PatternType type;

    public Pattern(PatternFactory.PatternType type) {
        this.type = type;
    }

    public static boolean sameGenre(PatternFactory.PatternType patternClass, Pattern p1, Pattern p2) {
        if (patternClass.equals((Object)PatternFactory.PatternType.SURFACE)) {
            return SurfacePattern.sameGenre((SurfacePattern)p1, (SurfacePattern)p2);
        }
        if (patternClass.equals((Object)PatternFactory.PatternType.DEP)) {
            return DepPattern.sameGenre((DepPattern)p1, (DepPattern)p2);
        }
        throw new UnsupportedOperationException();
    }

    public abstract CollectionValuedMap<String, String> getRelevantWords();

    public static boolean subsumes(PatternFactory.PatternType patternClass, Pattern pat, Pattern p) {
        if (patternClass.equals((Object)PatternFactory.PatternType.SURFACE)) {
            return SurfacePattern.subsumes((SurfacePattern)pat, (SurfacePattern)p);
        }
        if (patternClass.equals((Object)PatternFactory.PatternType.DEP)) {
            return DepPattern.subsumes((DepPattern)pat, (DepPattern)p);
        }
        throw new UnsupportedOperationException();
    }

    public abstract int equalContext(Pattern var1);

    public abstract String toStringSimple();

    public static Set getContext(PatternFactory.PatternType patternClass, DataInstance sent, int i, Set<CandidatePhrase> stopWords) {
        if (patternClass.equals((Object)PatternFactory.PatternType.SURFACE)) {
            return SurfacePatternFactory.getContext(sent.getTokens(), i, stopWords);
        }
        return DepPatternFactory.getContext(sent, i, stopWords);
    }

    public abstract String toString(List<String> var1);

    protected static void getRelevantWordsBase(Token[] t, CollectionValuedMap<String, String> relWords) {
        if (t != null) {
            for (Token s : t) {
                Map<String, String> str = s.classORRestrictionsAsString();
                if (str == null) continue;
                relWords.addAll(str);
            }
        }
    }

    protected static void getRelevantWordsBase(Token t, CollectionValuedMap<String, String> relWords) {
        Map<String, String> str;
        if (t != null && (str = t.classORRestrictionsAsString()) != null) {
            relWords.addAll(str);
        }
    }
}

